/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.consumer;

import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.wrapped.OffsetAndMetadataUtil;
import io.axual.client.proxy.wrapped.generic.WrappedClientProxy;
import io.axual.client.proxy.wrapped.generic.WrappedClientProxyConfig;
import io.axual.common.tools.MapUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;

public class WrappedConsumer<K, V>
extends WrappedClientProxy<ConsumerProxy<K, V>, WrappedClientProxyConfig<ConsumerProxy<K, V>>>
implements ConsumerProxy<K, V> {
    private final Consumer<K, V> consumer;

    public WrappedConsumer(Consumer<K, V> consumer, Map<String, Object> configs) {
        super(new WrappedClientProxyConfig(configs));
        this.consumer = consumer;
    }

    public WrappedConsumer(Map<String, Object> configs) {
        this((Consumer<K, V>)new KafkaConsumer(configs), configs);
    }

    public WrappedConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(SerdeUtil.addDeserializersToConfigs(configs, keyDeserializer, valueDeserializer));
    }

    public WrappedConsumer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public WrappedConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(MapUtil.objectToStringMap((Map)properties), keyDeserializer, valueDeserializer);
    }

    public Set<TopicPartition> assignment() {
        return this.consumer.assignment();
    }

    public Set<String> subscription() {
        return this.consumer.subscription();
    }

    public void subscribe(Collection<String> collection) {
        this.consumer.subscribe(collection);
    }

    public void subscribe(Collection<String> collection, ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumer.subscribe(collection, consumerRebalanceListener);
    }

    public void assign(Collection<TopicPartition> collection) {
        this.consumer.assign(collection);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumer.subscribe(pattern, consumerRebalanceListener);
    }

    public void subscribe(Pattern pattern) {
        this.consumer.subscribe(pattern);
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return this.consumer.poll(timeout);
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        return this.consumer.poll(duration);
    }

    public void commitSync() {
        this.consumer.commitSync();
    }

    public void commitSync(Duration duration) {
        this.consumer.commitSync(duration);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.consumer.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration duration) {
        this.consumer.commitSync(offsets, duration);
    }

    public void commitAsync() {
        this.consumer.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback offsetCommitCallback) {
        this.consumer.commitAsync(offsetCommitCallback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> map, OffsetCommitCallback offsetCommitCallback) {
        this.consumer.commitAsync(map, offsetCommitCallback);
    }

    public void seek(TopicPartition topicPartition, long offset) {
        this.consumer.seek(topicPartition, offset);
    }

    public void seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        this.consumer.seek(topicPartition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> collection) {
        this.consumer.seekToBeginning(collection);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.consumer.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.consumer.position(partition);
    }

    public long position(TopicPartition partition, Duration duration) {
        return this.consumer.position(partition, duration);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return OffsetAndMetadataUtil.INSTANCE.cleanMetadata(this.consumer.committed(partition));
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration duration) {
        return OffsetAndMetadataUtil.INSTANCE.cleanMetadata(this.consumer.committed(partition, duration));
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return OffsetAndMetadataUtil.INSTANCE.cleanMetadata(this.consumer.committed(partitions));
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return OffsetAndMetadataUtil.INSTANCE.cleanMetadata(this.consumer.committed(partitions, timeout));
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.consumer.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration duration) {
        return this.consumer.partitionsFor(topic, duration);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.consumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration duration) {
        return this.consumer.listTopics(duration);
    }

    public Set<TopicPartition> paused() {
        return this.consumer.paused();
    }

    public void pause(Collection<TopicPartition> collection) {
        this.consumer.pause(collection);
    }

    public void resume(Collection<TopicPartition> collection) {
        this.consumer.resume(collection);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestamps) {
        return this.consumer.offsetsForTimes(timestamps);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestamps, Duration duration) {
        return this.consumer.offsetsForTimes(timestamps, duration);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration duration) {
        return this.consumer.beginningOffsets(partitions, duration);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration duration) {
        return this.consumer.endOffsets(partitions, duration);
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.consumer.currentLag(topicPartition);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.consumer.groupMetadata();
    }

    public void enforceRebalance() {
        this.consumer.enforceRebalance();
    }

    public void enforceRebalance(String reason) {
        this.consumer.enforceRebalance(reason);
    }

    @Override
    public void close(Duration timeout) {
        this.consumer.close(timeout);
    }

    public void wakeup() {
        this.consumer.wakeup();
    }
}

