/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.producer;

import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.wrapped.generic.WrappedClientProxy;
import io.axual.client.proxy.wrapped.generic.WrappedClientProxyConfig;
import io.axual.common.tools.MapUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;

public class WrappedProducer<K, V>
extends WrappedClientProxy<ProducerProxy<K, V>, WrappedClientProxyConfig<ProducerProxy<K, V>>>
implements ProducerProxy<K, V> {
    private final Producer<K, V> producer;

    public WrappedProducer(Producer<K, V> producer, Map<String, Object> configs) {
        super(new WrappedClientProxyConfig(configs));
        this.producer = producer;
    }

    public WrappedProducer(Map<String, Object> configs) {
        this((Producer<K, V>)new KafkaProducer(configs), configs);
    }

    public WrappedProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(SerdeUtil.addSerializersToConfigs(configs, keySerializer, valueSerializer));
    }

    public WrappedProducer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public WrappedProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(MapUtil.objectToStringMap((Map)properties), keySerializer, valueSerializer);
    }

    public void initTransactions() {
        this.producer.initTransactions();
    }

    public void beginTransaction() {
        this.producer.beginTransaction();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> map, String s) {
        this.producer.sendOffsetsToTransaction(map, s);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.producer.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    public void commitTransaction() {
        this.producer.commitTransaction();
    }

    public void abortTransaction() {
        this.producer.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord) {
        return this.producer.send(producerRecord);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord, Callback callback) {
        return this.producer.send(producerRecord, callback);
    }

    public void flush() {
        this.producer.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.producer.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.producer.metrics();
    }

    @Override
    public void close(Duration timeout) {
        this.producer.close(timeout);
    }
}

