/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.serde;

import io.axual.client.proxy.generic.proxy.BaseProxy;
import io.axual.client.proxy.generic.serde.DeserializerProxy;
import io.axual.client.proxy.wrapped.serde.WrappedDeserializerConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class WrappedDeserializer<T>
extends BaseProxy<WrappedDeserializerConfig>
implements DeserializerProxy<T> {
    private Deserializer<T> deserializer;

    public WrappedDeserializer() {
        super(null);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.config = new WrappedDeserializerConfig(new HashMap(configs), isKey);
        this.deserializer = ((WrappedDeserializerConfig)this.config).getDeserializer();
    }

    public T deserialize(String topic, byte[] data) {
        return (T)this.deserializer.deserialize(topic, data);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        return (T)this.deserializer.deserialize(topic, headers, data);
    }

    @Override
    public void close(Duration timeout) {
        if (this.deserializer != null) {
            this.deserializer.close();
            this.deserializer = null;
        }
        super.close(timeout);
    }
}

