/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.serde;

import io.axual.client.proxy.generic.proxy.BaseSerdeConfig;
import io.axual.client.proxy.generic.serde.DeserializerProxyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class WrappedDeserializerConfig<T>
extends BaseSerdeConfig {
    public static final String DESERIALIZER_CONFIG = "wrappeddeserializer.deserializer";
    private final Deserializer<T> deserializer;

    public WrappedDeserializerConfig(Map<String, ?> configs, boolean isKey) {
        super(configs, isKey);
        this.filterDownstream(new String[]{DESERIALIZER_CONFIG});
        Object deserializerConfig = configs.get(DESERIALIZER_CONFIG);
        if (deserializerConfig instanceof DeserializerProxyFactory) {
            this.deserializer = ((DeserializerProxyFactory)deserializerConfig).create(new HashMap<String, Object>(this.getDownstreamConfigs()), isKey);
        } else {
            this.deserializer = (Deserializer)this.getConfiguredInstance(DESERIALIZER_CONFIG, Deserializer.class);
            this.deserializer.configure(this.getDownstreamConfigs(), isKey);
        }
    }

    public Deserializer<T> getDeserializer() {
        return this.deserializer;
    }
}

