/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.spring;

import io.axual.client.AxualClient;
import io.axual.client.spring.AxualClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@ConditionalOnProperty(value={"axual.client.enable"})
public class AxualClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AxualClientAutoConfiguration.class);
    private final AxualClientProperties config;

    @Autowired
    public AxualClientAutoConfiguration(AxualClientProperties config) {
        this.config = config;
    }

    @Bean
    @ConditionalOnMissingBean
    public AxualClient axualClient() {
        return new AxualClient(this.config.asClientConfig());
    }
}

