/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.spring;

import io.axual.common.config.ClientConfig;
import io.axual.common.config.PasswordConfig;
import io.axual.common.config.SslConfig;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="axual.client")
public class AxualClientProperties {
    @NotBlank
    private String applicationId;
    @NotBlank
    private String applicationVersion;
    @NotBlank
    private String endpoint;
    @NotBlank
    private String tenant;
    @NotBlank
    private String environment;
    @NotBlank
    private String sslKeyPassword;
    @NotBlank
    private String sslKeystoreLocation;
    @NotBlank
    private String sslKeystorePassword;
    @NotBlank
    private String sslTruststoreLocation;
    @NotBlank
    private String sslTruststorePassword;
    private Boolean enableHostnameVerification = false;
    private Boolean enableValidateTruststore = true;

    public ClientConfig asClientConfig() {
        return ClientConfig.newBuilder().setApplicationId(this.applicationId).setApplicationVersion(this.applicationVersion).setEndpoint(this.endpoint).setTenant(this.tenant).setEnvironment(this.environment).setSslConfig(SslConfig.newBuilder().setKeyPassword(new PasswordConfig(this.sslKeyPassword)).setKeystoreLocation(this.sslKeystoreLocation).setKeystorePassword(new PasswordConfig(this.sslKeystorePassword)).setTruststoreLocation(this.sslTruststoreLocation).setTruststorePassword(new PasswordConfig(this.sslTruststorePassword)).setEnableHostnameVerification(this.enableHostnameVerification.booleanValue()).setEnableValidateTruststore(this.enableValidateTruststore.booleanValue()).build()).build();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslKeystoreLocation() {
        return this.sslKeystoreLocation;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public Boolean getEnableHostnameVerification() {
        return this.enableHostnameVerification;
    }

    public Boolean getEnableValidateTruststore() {
        return this.enableValidateTruststore;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setEnableHostnameVerification(Boolean enableHostnameVerification) {
        this.enableHostnameVerification = enableHostnameVerification;
    }

    public void setEnableValidateTruststore(Boolean enableValidateTruststore) {
        this.enableValidateTruststore = enableValidateTruststore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AxualClientProperties)) {
            return false;
        }
        AxualClientProperties other = (AxualClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$sslKeyPassword = this.getSslKeyPassword();
        String other$sslKeyPassword = other.getSslKeyPassword();
        if (this$sslKeyPassword == null ? other$sslKeyPassword != null : !this$sslKeyPassword.equals(other$sslKeyPassword)) {
            return false;
        }
        String this$sslKeystoreLocation = this.getSslKeystoreLocation();
        String other$sslKeystoreLocation = other.getSslKeystoreLocation();
        if (this$sslKeystoreLocation == null ? other$sslKeystoreLocation != null : !this$sslKeystoreLocation.equals(other$sslKeystoreLocation)) {
            return false;
        }
        String this$sslKeystorePassword = this.getSslKeystorePassword();
        String other$sslKeystorePassword = other.getSslKeystorePassword();
        if (this$sslKeystorePassword == null ? other$sslKeystorePassword != null : !this$sslKeystorePassword.equals(other$sslKeystorePassword)) {
            return false;
        }
        String this$sslTruststoreLocation = this.getSslTruststoreLocation();
        String other$sslTruststoreLocation = other.getSslTruststoreLocation();
        if (this$sslTruststoreLocation == null ? other$sslTruststoreLocation != null : !this$sslTruststoreLocation.equals(other$sslTruststoreLocation)) {
            return false;
        }
        String this$sslTruststorePassword = this.getSslTruststorePassword();
        String other$sslTruststorePassword = other.getSslTruststorePassword();
        if (this$sslTruststorePassword == null ? other$sslTruststorePassword != null : !this$sslTruststorePassword.equals(other$sslTruststorePassword)) {
            return false;
        }
        Boolean this$enableHostnameVerification = this.getEnableHostnameVerification();
        Boolean other$enableHostnameVerification = other.getEnableHostnameVerification();
        if (this$enableHostnameVerification == null ? other$enableHostnameVerification != null : !((Object)this$enableHostnameVerification).equals(other$enableHostnameVerification)) {
            return false;
        }
        Boolean this$enableValidateTruststore = this.getEnableValidateTruststore();
        Boolean other$enableValidateTruststore = other.getEnableValidateTruststore();
        return !(this$enableValidateTruststore == null ? other$enableValidateTruststore != null : !((Object)this$enableValidateTruststore).equals(other$enableValidateTruststore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AxualClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $sslKeyPassword = this.getSslKeyPassword();
        result = result * 59 + ($sslKeyPassword == null ? 43 : $sslKeyPassword.hashCode());
        String $sslKeystoreLocation = this.getSslKeystoreLocation();
        result = result * 59 + ($sslKeystoreLocation == null ? 43 : $sslKeystoreLocation.hashCode());
        String $sslKeystorePassword = this.getSslKeystorePassword();
        result = result * 59 + ($sslKeystorePassword == null ? 43 : $sslKeystorePassword.hashCode());
        String $sslTruststoreLocation = this.getSslTruststoreLocation();
        result = result * 59 + ($sslTruststoreLocation == null ? 43 : $sslTruststoreLocation.hashCode());
        String $sslTruststorePassword = this.getSslTruststorePassword();
        result = result * 59 + ($sslTruststorePassword == null ? 43 : $sslTruststorePassword.hashCode());
        Boolean $enableHostnameVerification = this.getEnableHostnameVerification();
        result = result * 59 + ($enableHostnameVerification == null ? 43 : ((Object)$enableHostnameVerification).hashCode());
        Boolean $enableValidateTruststore = this.getEnableValidateTruststore();
        result = result * 59 + ($enableValidateTruststore == null ? 43 : ((Object)$enableValidateTruststore).hashCode());
        return result;
    }

    public String toString() {
        return "AxualClientProperties(applicationId=" + this.getApplicationId() + ", applicationVersion=" + this.getApplicationVersion() + ", endpoint=" + this.getEndpoint() + ", tenant=" + this.getTenant() + ", environment=" + this.getEnvironment() + ", sslKeyPassword=" + this.getSslKeyPassword() + ", sslKeystoreLocation=" + this.getSslKeystoreLocation() + ", sslKeystorePassword=" + this.getSslKeystorePassword() + ", sslTruststoreLocation=" + this.getSslTruststoreLocation() + ", sslTruststorePassword=" + this.getSslTruststorePassword() + ", enableHostnameVerification=" + this.getEnableHostnameVerification() + ", enableValidateTruststore=" + this.getEnableValidateTruststore() + ")";
    }
}

