package io.axual.client.consumer;

/*-
 * ========================LICENSE_START=================================
 * axual-client
 * %%
 * Copyright (C) 2020 Axual B.V.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */

import java.util.UUID;

public interface ConsumerMessage<K, V> {
    String getProducerId();

    String getProducerVersion();

    String getIntermediateId();

    String getIntermediateVersion();

    String getSystem();

    String getComponent();

    String getInstance();

    String getTenant();

    String getEnvironment();

    String getStream();

    int getPartition();

    long getOffset();

    long getTimestamp();

    UUID getId();

    Long getSerializationTime();

    Long getDeserializationTime();

    K getKey();

    V getValue();
}
