/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client;

import io.axual.client.config.ConsumerConfig;
import io.axual.client.config.GenericAvroConsumerConfig;
import io.axual.client.config.GenericAvroProducerConfig;
import io.axual.client.config.ProducerConfig;
import io.axual.client.config.SpecificAvroConsumerConfig;
import io.axual.client.config.SpecificAvroProducerConfig;
import io.axual.client.consumer.Consumer;
import io.axual.client.consumer.Processor;
import io.axual.client.consumer.avro.AvroConsumer;
import io.axual.client.consumer.avro.AvroMessageSource;
import io.axual.client.consumer.generic.GenericConsumer;
import io.axual.client.consumer.generic.GenericMessageSource;
import io.axual.client.janitor.Janitor;
import io.axual.client.janitor.TemporaryFile;
import io.axual.client.producer.Producer;
import io.axual.client.producer.avro.GenericAvroProducer;
import io.axual.client.producer.generic.GenericProducer;
import io.axual.client.producer.generic.ProducerWorkerManager;
import io.axual.common.config.ClientConfig;
import io.axual.common.config.PasswordConfig;
import io.axual.common.config.SslConfig;
import io.axual.common.tools.ResourceUtil;
import io.axual.common.tools.SslUtil;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxualClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AxualClient.class);
    private final ClientConfig config;
    private final Janitor janitor = new Janitor();
    private final ProducerWorkerManager producerWorkerManager = new ProducerWorkerManager();

    public AxualClient(ClientConfig config) {
        String truststoreFile;
        String keystoreFile;
        LOG.debug(config.getDisableTemporarySecurityFile() ? "Using original keystore and truststore files as creation of temporary files is disabled." : "Creating temporary keystore and truststore files.");
        if (config.getDisableTemporarySecurityFile()) {
            keystoreFile = config.getSslConfig().getKeystoreLocation();
            truststoreFile = config.getSslConfig().getTruststoreLocation();
        } else {
            TemporaryFile temporaryKeystoreFile = new TemporaryFile(ResourceUtil.getResourceAsFile((String)config.getSslConfig().getKeystoreLocation(), (String)config.getTempDir()));
            keystoreFile = this.janitor.register(temporaryKeystoreFile, false).getFilename();
            TemporaryFile temporaryTruststoreFile = new TemporaryFile(ResourceUtil.getResourceAsFile((String)config.getSslConfig().getTruststoreLocation(), (String)config.getTempDir()));
            truststoreFile = this.janitor.register(temporaryTruststoreFile, false).getFilename();
        }
        LOG.debug("Keystore file path: {}, Truststore file path: {} ", (Object)keystoreFile, (Object)truststoreFile);
        SslConfig updatedSslConfig = SslConfig.newBuilder((SslConfig)config.getSslConfig()).setTruststoreLocation(truststoreFile).setKeystoreLocation(keystoreFile).build();
        this.config = ClientConfig.newBuilder((ClientConfig)config).setSslConfig(updatedSslConfig).build();
        SslUtil.validateCertificateStore((String)"Truststore", (String)this.config.getSslConfig().getTruststoreLocation(), (PasswordConfig)this.config.getSslConfig().getTruststorePassword(), (String)this.config.getSslConfig().getKeystoreType().name(), (boolean)this.config.getSslConfig().getEnableValidateTruststore());
        SslUtil.validateCertificateStore((String)"Keystore", (String)this.config.getSslConfig().getKeystoreLocation(), (PasswordConfig)this.config.getSslConfig().getKeystorePassword(), (String)this.config.getSslConfig().getTruststoreType().name(), (boolean)true);
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public <K, V> Consumer<K, V> buildConsumer(ConsumerConfig<K, V> consumerConfig, Processor<K, V> processor) {
        return this.janitor.register(new GenericConsumer<K, V>(new GenericMessageSource<K, V>(this.config, consumerConfig), processor));
    }

    public Consumer<GenericRecord, GenericRecord> buildConsumer(GenericAvroConsumerConfig consumerConfig, Processor<GenericRecord, GenericRecord> processor) {
        return this.janitor.register(new AvroConsumer<GenericRecord, GenericRecord>(new AvroMessageSource<GenericRecord, GenericRecord>(this.config, consumerConfig), processor));
    }

    public <K extends SpecificRecord, V extends SpecificRecord> Consumer<K, V> buildConsumer(SpecificAvroConsumerConfig<K, V> consumerConfig, Processor<K, V> processor) {
        return this.janitor.register(new AvroConsumer<K, V>(new AvroMessageSource<K, V>(this.config, consumerConfig), processor));
    }

    public <K, V> Producer<K, V> buildProducer(ProducerConfig<K, V> producerConfig) {
        return this.janitor.register(new GenericProducer<K, V>(this.config, producerConfig, this.producerWorkerManager));
    }

    public Producer<GenericRecord, GenericRecord> buildProducer(GenericAvroProducerConfig producerConfig) {
        return this.janitor.register(new GenericAvroProducer<GenericRecord, GenericRecord>(this.config, producerConfig, this.producerWorkerManager));
    }

    public <K extends SpecificRecord, V extends SpecificRecord> Producer<K, V> buildProducer(SpecificAvroProducerConfig<K, V> producerConfig) {
        return this.janitor.register(new GenericAvroProducer<K, V>(this.config, producerConfig, this.producerWorkerManager));
    }

    @Override
    public void close() {
        LOG.info("Closing AxualClient {}", (Object)this.config.getApplicationId());
        this.producerWorkerManager.close();
        this.janitor.close();
    }
}

