/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.janitor;

import io.axual.client.janitor.Janitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFile
extends Janitor.ManagedCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryFile.class);
    private final String filename;

    public TemporaryFile(String filename) {
        this.filename = filename;
    }

    @Override
    public void close() {
        LOG.debug("Cleaning up temporary file: {}", (Object)this.filename);
        try {
            Files.deleteIfExists(Paths.get(this.filename, new String[0]));
        }
        catch (IOException e) {
            LOG.warn("Could not delete temporary file: {}", (Object)this.filename);
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

