/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.producer;

import io.axual.client.proxy.generic.producer.ExtendedProducerRecord;
import io.axual.common.exception.ClientException;
import io.axual.serde.utils.HeaderUtils;
import java.util.UUID;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class ProducerMessage<K, V> {
    private final ExtendedProducerRecord<K, V> record;

    private ProducerMessage(Builder<K, V> builder) {
        this.record = new ExtendedProducerRecord(((Builder)builder).stream, null, ((Builder)builder).timestamp, ((Builder)builder).key, ((Builder)builder).value, (Iterable)new RecordHeaders(), null);
        if (((Builder)builder).messageId != null) {
            HeaderUtils.addUuidHeader((Headers)this.record.headers(), (String)"Axual-Message-Id", (UUID)((Builder)builder).messageId);
        }
    }

    public String getStream() {
        return this.record.topic();
    }

    public K getKey() {
        return (K)this.record.key();
    }

    public V getValue() {
        return (V)this.record.value();
    }

    public Long getTimestamp() {
        return this.record.timestamp();
    }

    public UUID getMessageId() {
        return HeaderUtils.decodeUuidHeader((Header)this.record.headers().lastHeader("Axual-Message-Id"));
    }

    public ProducerRecord<K, V> getProducerRecord() {
        return this.record;
    }

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        private String stream = null;
        private K key = null;
        private V value = null;
        private Long timestamp = null;
        private UUID messageId = null;

        protected void validate() {
            if (this.stream == null) {
                throw new ClientException("Producer stream cannot be null");
            }
            if (this.messageId == null) {
                this.messageId = UUID.randomUUID();
            }
        }

        public ProducerMessage<K, V> build() {
            this.validate();
            return new ProducerMessage(this);
        }

        public String getStream() {
            return this.stream;
        }

        public Builder<K, V> setStream(String stream) {
            this.stream = stream;
            return this;
        }

        public K getKey() {
            return this.key;
        }

        public Builder<K, V> setKey(K key) {
            this.key = key;
            return this;
        }

        public V getValue() {
            return this.value;
        }

        public Builder<K, V> setValue(V value) {
            this.value = value;
            return this;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public Builder<K, V> setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public UUID getMessageId() {
            return this.messageId;
        }

        public Builder<K, V> setMessageId(UUID messageId) {
            this.messageId = messageId;
            return this;
        }
    }
}

