/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.producer.avro;

import io.axual.client.exception.NoExistingSchemaException;
import io.axual.client.producer.ProduceCallback;
import io.axual.client.producer.ProducerMessage;
import io.axual.client.producer.generic.ProduceFuture;
import io.axual.client.producer.generic.ProduceJob;
import io.axual.client.proxy.generic.producer.ProducerProxy;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroProduceJob<K extends GenericContainer, V extends GenericContainer>
extends ProduceJob<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroProduceJob.class);

    AvroProduceJob(ProducerMessage<K, V> message, ProduceCallback<K, V> produceCallback) {
        super(message, produceCallback);
    }

    @Override
    public ProduceFuture<K, V> execute(ProducerProxy<K, V> producer) {
        try {
            return super.execute(producer);
        }
        catch (KafkaException e) {
            String srUrls = producer.getStringConfig("schema.registry.url");
            NoExistingSchemaException.handleException((Exception)((Object)e), this.getMessage().getStream(), srUrls);
            throw e;
        }
        catch (NoExistingSchemaException e) {
            if (this.getMessage().getKey() != null) {
                LOG.error("  Key schema: {}", (Object)((GenericContainer)this.getMessage().getKey()).getSchema());
            }
            if (this.getMessage().getValue() != null) {
                LOG.error("  Value schema: {}", (Object)((GenericContainer)this.getMessage().getValue()).getSchema());
            }
            throw e;
        }
    }
}

