/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.producer.generic;

import io.axual.client.config.BaseProducerConfig;
import io.axual.client.janitor.Janitor;
import io.axual.client.producer.ProduceCallback;
import io.axual.client.producer.ProducedMessage;
import io.axual.client.producer.Producer;
import io.axual.client.producer.ProducerMessage;
import io.axual.client.producer.generic.ProduceJob;
import io.axual.client.producer.generic.ProduceJobFactory;
import io.axual.client.producer.generic.ProducerWorker;
import io.axual.client.producer.generic.ProducerWorkerManager;
import io.axual.common.config.ClientConfig;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericProducer<K, V>
extends Janitor.ManagedCloseable
implements Producer<K, V>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GenericProducer.class);
    private final ProducerWorker<K, V> worker;
    private final ProduceJobFactory<K, V> jobFactory;
    private final ProducerWorkerManager producerWorkerManager;

    public GenericProducer(ClientConfig clientConfig, BaseProducerConfig<K, V> producerConfig, ProducerWorkerManager producerWorkerManager) {
        this(clientConfig, producerConfig, producerWorkerManager, ProduceJob::new);
    }

    public GenericProducer(ClientConfig clientConfig, BaseProducerConfig<K, V> producerConfig, ProducerWorkerManager producerWorkerManager, ProduceJobFactory<K, V> jobFactory) {
        this.producerWorkerManager = producerWorkerManager;
        this.worker = this.producerWorkerManager.claimWorker(clientConfig, this, producerConfig);
        LOG.info("Created producer of type {}/{}.", (Object)producerConfig.getDeliveryStrategy(), (Object)producerConfig.getOrderingStrategy());
        this.jobFactory = jobFactory;
    }

    @Override
    public void close() {
        this.producerWorkerManager.releaseWorker(this);
        super.close();
    }

    @Override
    public Future<ProducedMessage<K, V>> produce(ProducerMessage<K, V> message) {
        return this.produce(message, null);
    }

    @Override
    public Future<ProducedMessage<K, V>> produce(ProducerMessage<K, V> message, ProduceCallback<K, V> produceCallback) {
        return this.worker.queueJob(this.jobFactory.createNewJob(message, produceCallback));
    }
}

