/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.producer.generic;

import io.axual.client.producer.ProducedMessage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ProduceFuture<K, V>
implements Future<ProducedMessage<K, V>> {
    private static final int SLEEP_TIME_MILLISECONDS = 10;
    private static final long MULTIPLIER_DEFAULT = 0L;
    private static final long MULTIPLIER_MILLISECONDS = 1L;
    private static final long MULTIPLIER_SECONDS = 1000L;
    private static final long MULTIPLIER_MINUTES = 60000L;
    private static final long MULTIPLIER_HOURS = 3600000L;
    private static final long MULTIPLIER_DAYS = 86400000L;
    private ProducedMessage<K, V> producedMessage = null;
    private ExecutionException executionException = null;
    private boolean isCancelled = false;

    public synchronized void complete(ProducedMessage<K, V> producedMessage) {
        this.producedMessage = producedMessage;
    }

    public synchronized void complete(ExecutionException executionException) {
        this.executionException = executionException;
    }

    public ProducedMessage<K, V> getProducedMessage() {
        return this.producedMessage;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.isCancelled = true;
        this.executionException = new ExecutionException(new CancellationException("Execution cancelled"));
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.producedMessage != null || this.executionException != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducedMessage<K, V> get() throws InterruptedException, ExecutionException {
        while (!this.isDone()) {
            Thread.sleep(10L);
        }
        ProduceFuture produceFuture = this;
        synchronized (produceFuture) {
            if (this.executionException != null) {
                throw this.executionException;
            }
            return this.producedMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducedMessage<K, V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long multiplier;
        long currentTime = System.currentTimeMillis();
        switch (unit) {
            case MILLISECONDS: {
                multiplier = 1L;
                break;
            }
            case SECONDS: {
                multiplier = 1000L;
                break;
            }
            case MINUTES: {
                multiplier = 60000L;
                break;
            }
            case HOURS: {
                multiplier = 3600000L;
                break;
            }
            case DAYS: {
                multiplier = 86400000L;
                break;
            }
            default: {
                multiplier = 0L;
            }
        }
        long timeoutTime = currentTime + multiplier * timeout;
        while (true) {
            if (this.isDone()) {
                ProduceFuture produceFuture = this;
                synchronized (produceFuture) {
                    if (this.executionException != null) {
                        throw this.executionException;
                    }
                    return this.producedMessage;
                }
            }
            if (System.currentTimeMillis() > timeoutTime) {
                throw new TimeoutException();
            }
            Thread.sleep(10L);
        }
    }
}

