/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.protocol.s3;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class Handler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private final S3Client client;
    private static final Pattern LEADING_SLASHES_PATTERN = Pattern.compile("^/+");

    public Handler() {
        this(S3Client.create());
    }

    @Override
    protected URLConnection openConnection(URL url) {
        return new URLConnection(url){
            private ResponseInputStream<GetObjectResponse> inputStream;
            private Map<String, List<String>> headers;

            @Override
            public String getHeaderField(String name) {
                return this.getHeaderFields().getOrDefault(name, Collections.emptyList()).stream().findFirst().orElse(null);
            }

            @Override
            public Map<String, List<String>> getHeaderFields() {
                this.connect();
                return Collections.unmodifiableMap(this.headers);
            }

            @Override
            public InputStream getInputStream() {
                this.connect();
                return this.inputStream;
            }

            @Override
            public void connect() {
                if (this.inputStream == null) {
                    try {
                        String bucket = Handler.stripLeadingSlashes(this.url.getHost());
                        String key = Handler.stripLeadingSlashes(this.url.getPath());
                        this.inputStream = Handler.this.client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build());
                        GetObjectResponse response = (GetObjectResponse)this.inputStream.response();
                        this.headers = new HashMap<String, List<String>>();
                        if (response.contentLength() != null) {
                            this.headers.put("content-length", (List<String>)ImmutableList.of((Object)Long.toString(response.contentLength())));
                        }
                        if (response.contentType() != null) {
                            this.headers.put("content-type", (List<String>)ImmutableList.of((Object)response.contentType()));
                        }
                        if (response.contentEncoding() != null) {
                            this.headers.put("content-encoding", (List<String>)ImmutableList.of((Object)response.contentEncoding()));
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to connect to {}", (Object)this.url, (Object)e);
                        throw e;
                    }
                }
            }
        };
    }

    private static String stripLeadingSlashes(String str) {
        return LEADING_SLASHES_PATTERN.matcher(str).replaceAll("");
    }

    public Handler(S3Client client) {
        this.client = client;
    }
}

