/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.storage.s3;

import io.basestar.schema.ObjectSchema;

public interface S3BlobRouting {
    public String objectBucket(ObjectSchema var1);

    public String historyBucket(ObjectSchema var1);

    public String objectPrefix(ObjectSchema var1);

    public String historyPrefix(ObjectSchema var1);

    public static class Simple
    implements S3BlobRouting {
        private final String bucket;
        private final String prefix;

        @Override
        public String objectBucket(ObjectSchema schema) {
            return this.bucket;
        }

        @Override
        public String historyBucket(ObjectSchema schema) {
            return this.bucket;
        }

        @Override
        public String objectPrefix(ObjectSchema schema) {
            return this.prefix(schema);
        }

        @Override
        public String historyPrefix(ObjectSchema schema) {
            return this.prefix(schema);
        }

        protected String prefix(ObjectSchema schema) {
            String base = this.prefix == null ? "" : this.prefix + (this.prefix.endsWith("/") ? "" : "/");
            return base + schema.getName() + "/";
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bucket = this.getBucket();
            String other$bucket = other.getBucket();
            if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Simple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bucket = this.getBucket();
            result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            return result;
        }

        public String toString() {
            return "S3BlobRouting.Simple(bucket=" + this.getBucket() + ", prefix=" + this.getPrefix() + ")";
        }

        public Simple(String bucket, String prefix) {
            this.bucket = bucket;
            this.prefix = prefix;
        }
    }
}

