/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.storage.s3;

import io.basestar.expression.Expression;
import io.basestar.schema.Consistency;
import io.basestar.schema.Index;
import io.basestar.schema.ObjectSchema;
import io.basestar.storage.BatchResponse;
import io.basestar.storage.Storage;
import io.basestar.storage.StorageTraits;
import io.basestar.storage.aggregate.Aggregate;
import io.basestar.storage.s3.S3BlobRouting;
import io.basestar.storage.s3.S3BlobStorageTraits;
import io.basestar.storage.util.Pager;
import io.basestar.util.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class S3BlobStorage
implements Storage {
    private final S3AsyncClient client;
    private final S3BlobRouting routing;

    private S3BlobStorage(Builder builder) {
        this.client = builder.client;
        this.routing = builder.routing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<Map<String, Object>> readObject(ObjectSchema schema, String id) {
        String bucket = this.routing.objectBucket(schema);
        String key = this.objectKey(schema, id);
        return this.readObjectImpl(bucket, key);
    }

    public CompletableFuture<Map<String, Object>> readObjectVersion(ObjectSchema schema, String id, long version) {
        String bucket = this.routing.historyBucket(schema);
        String key = this.historyKey(schema, id, version);
        return this.readObjectImpl(bucket, key);
    }

    private CompletableFuture<Map<String, Object>> readObjectImpl(String bucket, String key) {
        return this.readImpl(bucket, key).thenApply(bytes -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private CompletableFuture<byte[]> readImpl(String bucket, String key) {
        GetObjectRequest get = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
        return ((CompletableFuture)this.client.getObject(get, AsyncResponseTransformer.toBytes()).thenApply(BytesWrapper::asByteArray)).exceptionally(t -> {
            if (t.getCause() instanceof NoSuchKeyException) {
                return null;
            }
            if (t.getCause() instanceof RuntimeException) {
                throw (RuntimeException)t.getCause();
            }
            throw new IllegalStateException(t.getCause());
        });
    }

    public List<Pager.Source<Map<String, Object>>> query(ObjectSchema schema, Expression query, List<Sort> sort) {
        throw new UnsupportedOperationException();
    }

    public List<Pager.Source<Map<String, Object>>> aggregate(ObjectSchema schema, Expression query, Map<String, Expression> group, Map<String, Aggregate> aggregates) {
        throw new UnsupportedOperationException();
    }

    public Storage.ReadTransaction read(Consistency consistency) {
        return new Storage.ReadTransaction.Basic((Storage)this);
    }

    public Storage.WriteTransaction write(Consistency consistency) {
        return new Storage.WriteTransaction(){
            final List<Supplier<CompletableFuture<BatchResponse>>> steps = new ArrayList<Supplier<CompletableFuture<BatchResponse>>>();

            public Storage.WriteTransaction createObject(ObjectSchema schema, String id, Map<String, Object> after) {
                this.steps.add(() -> this.writeObject(schema, id, after).thenApply(v -> BatchResponse.single((String)schema.getName(), (Map)after)));
                return this;
            }

            public Storage.WriteTransaction updateObject(ObjectSchema schema, String id, Map<String, Object> before, Map<String, Object> after) {
                this.steps.add(() -> this.writeObject(schema, id, after).thenApply(v -> BatchResponse.single((String)schema.getName(), (Map)after)));
                return this;
            }

            private CompletableFuture<String> writeObject(ObjectSchema schema, String id, Map<String, Object> after) {
                byte[] object = this.encode(schema, after);
                String bucket = S3BlobStorage.this.routing.objectBucket(schema);
                String key = S3BlobStorage.this.objectKey(schema, id);
                return this.writeImpl(bucket, key, object);
            }

            private CompletableFuture<String> writeHistory(ObjectSchema schema, String id, long version, Map<String, Object> after) {
                byte[] object = this.encode(schema, after);
                String bucket = S3BlobStorage.this.routing.historyBucket(schema);
                String key = S3BlobStorage.this.historyKey(schema, id, version);
                return this.writeImpl(bucket, key, object);
            }

            /*
             * Exception decompiling
             */
            private byte[] encode(ObjectSchema schema, Map<String, Object> object) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private CompletableFuture<String> writeImpl(String bucket, String key, byte[] bytes) {
                PutObjectRequest put = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(key).build();
                return S3BlobStorage.this.client.putObject(put, AsyncRequestBody.fromBytes((byte[])bytes)).thenApply(PutObjectResponse::versionId);
            }

            public Storage.WriteTransaction deleteObject(ObjectSchema schema, String id, Map<String, Object> before) {
                String bucket = S3BlobStorage.this.routing.objectBucket(schema);
                String key = S3BlobStorage.this.objectKey(schema, id);
                DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build();
                this.steps.add(() -> S3BlobStorage.this.client.deleteObject(request).thenApply(v -> BatchResponse.empty()));
                return this;
            }

            public Storage.WriteTransaction createIndex(ObjectSchema schema, Index index, String id, long version, Index.Key key, Map<String, Object> projection) {
                throw new UnsupportedOperationException();
            }

            public Storage.WriteTransaction updateIndex(ObjectSchema schema, Index index, String id, long version, Index.Key key, Map<String, Object> projection) {
                throw new UnsupportedOperationException();
            }

            public Storage.WriteTransaction deleteIndex(ObjectSchema schema, Index index, String id, long version, Index.Key key) {
                throw new UnsupportedOperationException();
            }

            public Storage.WriteTransaction createHistory(ObjectSchema schema, String id, long version, Map<String, Object> after) {
                this.steps.add(() -> this.writeHistory(schema, id, version, after).thenApply(v -> BatchResponse.empty()));
                return this;
            }

            public CompletableFuture<BatchResponse> commit() {
                return BatchResponse.mergeFutures(this.steps.stream().map(Supplier::get));
            }
        };
    }

    public Storage.EventStrategy eventStrategy(ObjectSchema objectSchema) {
        return Storage.EventStrategy.EMIT;
    }

    public StorageTraits storageTraits(ObjectSchema schema) {
        return S3BlobStorageTraits.INSTANCE;
    }

    private String objectKey(ObjectSchema schema, String id) {
        String prefix = this.routing.objectPrefix(schema);
        return prefix + id;
    }

    private String historyKey(ObjectSchema schema, String id, long version) {
        String prefix = this.routing.historyPrefix(schema);
        return prefix + id + "/" + version;
    }

    public static class Builder {
        private S3AsyncClient client;
        private S3BlobRouting routing;

        public S3BlobStorage build() {
            return new S3BlobStorage(this);
        }

        public Builder setClient(S3AsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder setRouting(S3BlobRouting routing) {
            this.routing = routing;
            return this;
        }
    }
}

