/*
 * Decompiled with CFR 0.152.
 */
package io.basestar.storage.s3;

import io.basestar.storage.Stash;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Stash
implements Stash {
    private final S3AsyncClient client;
    private final String bucket;
    private final String prefix;

    private S3Stash(Builder builder) {
        this.client = builder.client;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<String> write(String id, byte[] data) {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(this.key(id)).build();
        return this.client.putObject(request, AsyncRequestBody.fromBytes((byte[])data)).thenApply(ignored -> id);
    }

    public CompletableFuture<byte[]> read(String ref) {
        GetObjectRequest get = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.key(ref)).build();
        return this.client.getObject(get, AsyncResponseTransformer.toBytes()).thenApply(BytesWrapper::asByteArray);
    }

    public CompletableFuture<?> delete(String ref) {
        DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(this.key(ref)).build();
        return this.client.deleteObject(request);
    }

    private String key(String ref) {
        return this.prefix + ref;
    }

    public static class Builder {
        private S3AsyncClient client;
        private String bucket;
        private String prefix;

        public S3Stash build() {
            return new S3Stash(this);
        }

        public Builder setClient(S3AsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }
    }
}

