/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.autoconfigure;

import io.beanmapper.annotations.LogicSecuredCheck;
import io.beanmapper.autoconfigure.BeanMapFromClass;
import io.beanmapper.autoconfigure.BeanMapToClass;
import io.beanmapper.core.collections.CollectionHandler;
import io.beanmapper.core.converter.BeanConverter;
import io.beanmapper.utils.Classes;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;

class ApplicationScanner {
    private final Logger log = LoggerFactory.getLogger(ApplicationScanner.class);
    private final EntityScanner entityScanner;
    private final ClassPathScanningCandidateComponentProvider classpathScanner;

    ApplicationScanner(ApplicationContext context) {
        this.entityScanner = new EntityScanner(context);
        this.classpathScanner = new ClassPathScanningCandidateComponentProvider(false);
        this.classpathScanner.setEnvironment(context.getEnvironment());
        this.classpathScanner.setResourceLoader((ResourceLoader)context);
    }

    Optional<String> findApplicationPackage() {
        try {
            Set appClasses = this.entityScanner.scan(new Class[]{SpringBootApplication.class});
            Class appClass = (Class)appClasses.iterator().next();
            return Optional.of(appClass.getPackage().getName());
        }
        catch (ClassNotFoundException | NoSuchElementException e) {
            this.log.error("Cannot find class annotated with SpringBootApplication. ", (Throwable)e);
            return Optional.empty();
        }
    }

    Set<Class<?>> findBeanPairInstructions() {
        Set<Class<?>> foundAnnotations = this.findBeanPairInstructions(BeanMapFromClass.class);
        foundAnnotations.addAll(this.findBeanPairInstructions(BeanMapToClass.class));
        return foundAnnotations;
    }

    private Set<Class<?>> findBeanPairInstructions(Class<? extends Annotation> markerAnnotation) {
        try {
            return this.entityScanner.scan(new Class[]{markerAnnotation});
        }
        catch (ClassNotFoundException | NoSuchElementException e) {
            return Collections.emptySet();
        }
    }

    Set<Class<? extends BeanConverter>> findBeanConverterClasses(String basePackage) {
        return this.findClasses(basePackage, BeanConverter.class);
    }

    Set<Class<? extends CollectionHandler>> findCollectionHandlerClasses(String basePackage) {
        return this.findClasses(basePackage, CollectionHandler.class);
    }

    Set<Class<? extends LogicSecuredCheck>> findLogicSecuredCheckClasses(String basePackage) {
        return this.findClasses(basePackage, LogicSecuredCheck.class);
    }

    private <T> Set<Class<? extends T>> findClasses(String basePackage, Class<T> lookForClass) {
        HashSet converterClasses = new HashSet();
        this.classpathScanner.addIncludeFilter(this.createTypeFilterForClass(lookForClass));
        this.classpathScanner.findCandidateComponents(basePackage).forEach(bd -> converterClasses.add(Classes.forName((String)bd.getBeanClassName())));
        this.classpathScanner.resetFilters(false);
        return converterClasses;
    }

    private TypeFilter createTypeFilterForClass(Class<?> clazz) {
        return (metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            Class currentClass = Classes.forName((String)className);
            return clazz.isAssignableFrom(currentClass);
        };
    }
}

