/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.autoconfigure;

import io.beanmapper.BeanMapper;
import io.beanmapper.annotations.LogicSecuredCheck;
import io.beanmapper.autoconfigure.ApplicationScanner;
import io.beanmapper.autoconfigure.BeanMapFromClass;
import io.beanmapper.autoconfigure.BeanMapToClass;
import io.beanmapper.autoconfigure.BeanMapperBuilderCustomizer;
import io.beanmapper.autoconfigure.BeanMapperProperties;
import io.beanmapper.config.AfterClearFlusher;
import io.beanmapper.config.BeanMapperBuilder;
import io.beanmapper.config.RoleSecuredCheck;
import io.beanmapper.core.collections.CollectionHandler;
import io.beanmapper.core.converter.BeanConverter;
import io.beanmapper.core.unproxy.BeanUnproxy;
import io.beanmapper.spring.converter.IdToEntityBeanConverter;
import io.beanmapper.spring.flusher.JpaAfterClearFlusher;
import io.beanmapper.spring.security.SpringRoleSecuredCheck;
import io.beanmapper.spring.unproxy.HibernateAwareBeanUnproxy;
import io.beanmapper.spring.web.MergedFormMethodArgumentResolver;
import io.beanmapper.spring.web.converter.StructuredJsonMessageConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableAspectJAutoProxy
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={BeanMapperProperties.class})
public class BeanMapperAutoConfig {
    private final Logger log = LoggerFactory.getLogger(BeanMapperAutoConfig.class);
    private final BeanMapperProperties props;
    private final ApplicationContext applicationContext;
    private final BeanMapperBuilderCustomizer builderCustomizer;
    private ApplicationScanner collectionHandlerAppScanner;
    private ApplicationScanner beanConverterAppScanner;

    public BeanMapperAutoConfig(BeanMapperProperties props, ApplicationContext applicationContext, @Autowired(required=false) BeanMapperBuilderCustomizer builderCustomizer) {
        this.props = props;
        this.applicationContext = applicationContext;
        this.builderCustomizer = builderCustomizer;
    }

    @PostConstruct
    private void initApplicationScanner() {
        this.collectionHandlerAppScanner = new ApplicationScanner(this.applicationContext);
        this.beanConverterAppScanner = new ApplicationScanner(this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanMapper.class})
    public BeanMapper beanMapper() {
        String packagePrefix = this.determinePackagePrefix();
        BeanMapperBuilder builder = new BeanMapperBuilder().setApplyStrictMappingConvention(this.props.getApplyStrictMappingConvention()).setStrictSourceSuffix(this.props.getStrictSourceSuffix()).setStrictTargetSuffix(this.props.getStrictTargetSuffix()).addPackagePrefix(packagePrefix);
        if (this.isSpringDataJpaOnClasspath()) {
            builder.addConverter((BeanConverter)new IdToEntityBeanConverter(this.applicationContext));
        } else {
            this.log.info("Spring Data JPA is not present on the classpath. BeanMapper's IdToEntityBeanConverter will not be activated");
        }
        this.addCollectionHandlers(builder, packagePrefix);
        this.addCustomConverters(builder, packagePrefix);
        this.addCustomBeanPairs(builder);
        if (this.isSpringDataJpaOnClasspath()) {
            this.addAfterClearFlusher(builder);
        } else {
            this.log.info("Spring Data JPA is not present on the classpath. BeanMapper's afterClearFlusher will not be activated");
        }
        if (this.isSpringSecurityOnClasspath()) {
            this.setSecuredChecks(builder, packagePrefix);
        } else {
            this.log.info("Spring Security is not present on the classpath. BeanMapper's @BeanLogicSecured and @BeanRoleSecured annotations will not be processed.");
        }
        this.setUnproxy(builder);
        this.customize(builder);
        BeanMapper beanMapper = builder.build();
        if (this.props.getDiagnosticsDetailLevel().isEnabled()) {
            beanMapper = beanMapper.wrap(this.props.getDiagnosticsDetailLevel()).build();
        }
        return beanMapper;
    }

    private void setSecuredChecks(BeanMapperBuilder builder, String packagePrefix) {
        if (!this.props.getApplySecuredProperties()) {
            return;
        }
        this.addLogicSecuredChecks(builder, packagePrefix);
        builder.setSecuredPropertyHandler((RoleSecuredCheck)new SpringRoleSecuredCheck());
    }

    private void addAfterClearFlusher(BeanMapperBuilder builder) {
        EntityManager entityManager;
        try {
            entityManager = (EntityManager)this.applicationContext.getBean(EntityManager.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.log.warn("No EntityManager bean has been configured within your application. BeanMapper's afterClearFlusher can not be activated.");
            return;
        }
        builder.addAfterClearFlusher((AfterClearFlusher)new JpaAfterClearFlusher(entityManager));
    }

    private String determinePackagePrefix() {
        String packagePrefix = this.props.getPackagePrefix();
        if (packagePrefix == null) {
            this.log.info("No beanmapper.package-prefix found in environment properties, defaulting to SpringBootApplication annotated class package.");
            packagePrefix = this.beanConverterAppScanner.findApplicationPackage().orElseThrow(() -> new RuntimeException("Application package not found, define beanmapper.package-prefix property in your environment!"));
        }
        this.log.info("Set beanmapper packagePrefix [{}]", (Object)packagePrefix);
        return packagePrefix;
    }

    private void addCustomBeanPairs(BeanMapperBuilder builder) {
        this.beanConverterAppScanner.findBeanPairInstructions().forEach(cls -> {
            BeanMapToClass beanMapToClass = cls.getDeclaredAnnotation(BeanMapToClass.class);
            BeanMapFromClass beanMapFromClass = cls.getDeclaredAnnotation(BeanMapFromClass.class);
            if (beanMapToClass != null) {
                builder.addBeanPairWithStrictSource(cls, beanMapToClass.target());
            } else if (beanMapFromClass != null) {
                builder.addBeanPairWithStrictTarget(beanMapFromClass.source(), cls);
            }
        });
    }

    private void addLogicSecuredChecks(BeanMapperBuilder builder, String basePackage) {
        this.collectionHandlerAppScanner.findLogicSecuredCheckClasses(basePackage).forEach(cls -> {
            LogicSecuredCheck logicSecuredCheck = (LogicSecuredCheck)this.instantiateClassAppContextOptional((Class)cls, "logic secured check");
            if (logicSecuredCheck == null) {
                try {
                    logicSecuredCheck = (LogicSecuredCheck)this.applicationContext.getBean(cls);
                }
                catch (BeansException e) {
                    this.log.error("Could not instantiate class [{}] as Spring Bean.", (Object)cls.getName());
                    return;
                }
            }
            builder.addLogicSecuredCheck(logicSecuredCheck);
        });
    }

    private void addCollectionHandlers(BeanMapperBuilder builder, String basePackage) {
        this.collectionHandlerAppScanner.findCollectionHandlerClasses(basePackage).forEach(cls -> {
            CollectionHandler collectionHandler = (CollectionHandler)this.instantiateClassAppContextOptional((Class)cls, "collection handler");
            if (collectionHandler != null) {
                builder.addCollectionHandler(collectionHandler);
            }
        });
    }

    private void addCustomConverters(BeanMapperBuilder builder, String basePackage) {
        this.beanConverterAppScanner.findBeanConverterClasses(basePackage).forEach(cls -> {
            BeanConverter converter = (BeanConverter)this.instantiateClassAppContextOptional((Class)cls, "bean converter");
            if (converter != null) {
                builder.addConverter(converter);
            }
        });
    }

    private <T> T instantiateClassAppContextOptional(Class<T> cls, String label) {
        this.log.info("Found {} candidate class [{}], now trying to instantiate...", (Object)label, cls);
        try {
            Object created = BeanUtils.instantiateClass(cls);
            this.log.info("Added [{}] [{}] to bean mapper.", (Object)label, cls);
            return (T)created;
        }
        catch (BeanInstantiationException e) {
            this.log.debug("Cannot instantiate bean of class [{}] with no-arg constructor, now trying appContext constructor...", cls);
            try {
                Object created = BeanUtils.instantiateClass(cls.getConstructor(ApplicationContext.class), (Object[])new Object[]{this.applicationContext});
                this.log.info("Added [{}] [{}] to bean mapper.", (Object)label, cls);
                return (T)created;
            }
            catch (NoSuchMethodException | SecurityException | BeanInstantiationException ex) {
                this.log.warn("Cannot instantiate bean of class [{}] with applicationContext constructor, this [{}] will be skipped!", cls, (Object)label);
                return null;
            }
        }
    }

    private void setUnproxy(BeanMapperBuilder builder) {
        if (this.props.isUseHibernateUnproxy()) {
            if (this.isHibernateOnClasspath()) {
                builder.setBeanUnproxy((BeanUnproxy)new HibernateAwareBeanUnproxy());
                this.log.info("Set HibernateAwareUnproxy as bean unproxy mechanism.");
            } else {
                this.log.warn("use-hibernate-unproxy was set to true, but no Hibernate / Spring Data JPA was found on your classpath. Did you perhaps forget to include spring-boot-start-data-jpa in your project?");
            }
        } else {
            this.log.info("use-hibernate-unproxy set to false, keeping default unproxy mechanism.");
        }
    }

    private void customize(BeanMapperBuilder builder) {
        if (this.builderCustomizer != null) {
            this.log.info("Customizing BeanMapperBuilder...");
            this.builderCustomizer.customize(builder);
        }
    }

    private boolean isSpringDataJpaOnClasspath() {
        return ClassUtils.isPresent((String)"jakarta.persistence.EntityManager", (ClassLoader)this.applicationContext.getClassLoader());
    }

    private boolean isHibernateOnClasspath() {
        return ClassUtils.isPresent((String)"org.hibernate.proxy.HibernateProxy", (ClassLoader)this.applicationContext.getClassLoader());
    }

    private boolean isSpringSecurityOnClasspath() {
        return ClassUtils.isPresent((String)"org.springframework.security.authentication.AuthenticationManager", (ClassLoader)this.applicationContext.getClassLoader());
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={EntityInformation.class})
    static class MergedFormConfig
    implements WebMvcConfigurer {
        private final Logger log = LoggerFactory.getLogger(MergedFormConfig.class);
        private final MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;
        private final BeanMapper beanMapper;
        private final ApplicationContext applicationContext;
        private final EntityManager entityManager;

        public MergedFormConfig(@Autowired(required=false) MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter, BeanMapper beanMapper, ApplicationContext applicationContext, @Autowired(required=false) EntityManager entityManager) {
            this.mappingJackson2HttpMessageConverter = mappingJackson2HttpMessageConverter;
            this.beanMapper = beanMapper;
            this.applicationContext = applicationContext;
            this.entityManager = entityManager;
        }

        public void addArgumentResolvers(@Nonnull List<HandlerMethodArgumentResolver> argumentResolvers) {
            if (this.mappingJackson2HttpMessageConverter != null) {
                this.log.info("Adding MergedFormArgumentResolver to MVC application.");
                argumentResolvers.add((HandlerMethodArgumentResolver)new MergedFormMethodArgumentResolver(Collections.singletonList(new StructuredJsonMessageConverter(this.mappingJackson2HttpMessageConverter)), this.beanMapper, this.applicationContext, this.entityManager));
            } else {
                this.log.warn("No MergedFormArgumentResolver added to MVC application because no MappingJackson2HttpMessageConverter bean found!");
            }
        }
    }
}

