/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring;

import io.beanmapper.BeanMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableMapper {
    private PageableMapper() {
    }

    public static <S, T> Page<T> map(Page<S> source, Class<T> targetClass, BeanMapper beanMapper) {
        List transformed;
        if (source.hasContent()) {
            ArrayList content = new ArrayList(source.getContent());
            transformed = beanMapper.map(content, targetClass);
        } else {
            transformed = Collections.emptyList();
        }
        PageRequest pageable = PageRequest.of((int)source.getNumber(), (int)source.getSize(), (Sort)source.getSort());
        return new PageImpl(transformed, (Pageable)pageable, source.getTotalElements());
    }
}

