/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    public static Set<String> getPropertyNamesFromJson(String json, ObjectMapper objectMapper) {
        try {
            JsonNode tree = objectMapper.readTree(json);
            return JsonUtil.getPropertyNames(tree, "");
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not retrieve property names from JSON.", e);
        }
    }

    private static Set<String> getPropertyNames(JsonNode node, String base) {
        HashSet<String> propertyNames = new HashSet<String>();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            String propertyName = StringUtils.isEmpty((CharSequence)base) ? fieldName : base + "." + fieldName;
            propertyNames.add(propertyName);
            propertyNames.addAll(JsonUtil.getPropertyNames(node.get(fieldName), propertyName));
        }
        return propertyNames;
    }
}

