/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.web.converter;

import com.google.common.io.CharStreams;
import io.beanmapper.spring.util.JsonUtil;
import io.beanmapper.spring.web.converter.StructuredBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class StructuredJsonMessageConverter
implements HttpMessageConverter<Object> {
    private final MappingJackson2HttpMessageConverter delegate;

    public StructuredJsonMessageConverter(MappingJackson2HttpMessageConverter delegate) {
        this.delegate = delegate;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.delegate.canRead(clazz, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.delegate.canWrite(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.delegate.getSupportedMediaTypes();
    }

    public Object read(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String json = CharStreams.toString((Readable)new InputStreamReader(inputMessage.getBody()));
        Object body = this.delegate.read(clazz, (HttpInputMessage)new StringHttpInputMessage(inputMessage.getHeaders(), json));
        Set<String> propertyNames = JsonUtil.getPropertyNamesFromJson(json, this.delegate.getObjectMapper());
        return new StructuredBody(body, propertyNames);
    }

    public void write(Object t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.delegate.write(t, contentType, outputMessage);
    }

    private static class StringHttpInputMessage
    implements HttpInputMessage {
        private final HttpHeaders headers;
        private final String content;

        public StringHttpInputMessage(HttpHeaders headers, String content) {
            this.headers = headers;
            this.content = content;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }
    }
}

