/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.web;

import io.beanmapper.BeanMapper;
import io.beanmapper.config.BeanMapperBuilder;
import io.beanmapper.spring.Lazy;
import io.beanmapper.spring.web.EntityFinder;
import io.beanmapper.spring.web.MergePair;
import io.beanmapper.spring.web.MergedForm;
import io.beanmapper.spring.web.SpringDataEntityFinder;
import io.beanmapper.spring.web.WebRequestParameters;
import io.beanmapper.spring.web.converter.StructuredBody;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestPartMethodArgumentResolver;

public class MergedFormMethodArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BeanMapper beanMapper;
    private final EntityFinder entityFinder;
    private final RequestPartMethodArgumentResolver multiPartResolver;
    private static final boolean FLUSH = true;
    private static final boolean NO_FLUSH = false;

    public MergedFormMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters, BeanMapper beanMapper, ApplicationContext applicationContext, EntityManager entityManager) {
        this(messageConverters, beanMapper, new SpringDataEntityFinder(applicationContext, entityManager));
    }

    public MergedFormMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters, BeanMapper beanMapper, EntityFinder entityFinder) {
        super(messageConverters);
        this.beanMapper = beanMapper;
        this.entityFinder = entityFinder;
        this.multiPartResolver = new RequestPartMethodArgumentResolver(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(MergedForm.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        MergedForm annotation = (MergedForm)parameter.getParameterAnnotation(MergedForm.class);
        Class parameterType = parameter.getParameterType();
        Long id = this.resolveId(webRequest, annotation.mergeId());
        Object form = annotation.multiPart().length() > 0 ? this.readFromMultiPartForm(parameter, mavContainer, webRequest, binderFactory, annotation) : this.readWithMessageConverters(webRequest, parameter, annotation.value());
        WebRequestParameters webRequestParameters = new WebRequestParameters(parameter, mavContainer, webRequest, binderFactory);
        this.validateObject(webRequestParameters, this.getBody(form));
        if (Lazy.class.isAssignableFrom(parameterType)) {
            ParameterizedType genericType = (ParameterizedType)parameter.getGenericParameterType();
            Type entityType = genericType.getActualTypeArguments()[0];
            return new LazyResolveEntity(form, id, (Class)entityType, annotation, webRequestParameters);
        }
        return this.resolveEntity(form, id, parameterType, annotation, webRequestParameters, false);
    }

    private Object readFromMultiPartForm(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, MergedForm annotation) throws Exception {
        MethodParameter formParameter = new MethodParameter(parameter);
        this.setMethodParameterField(formParameter, "parameterType", annotation.value());
        this.setMethodParameterField(formParameter, "genericParameterType", annotation.value());
        this.setMethodParameterField(formParameter, "parameterName", annotation.multiPart());
        this.setMethodParameterField(formParameter, "parameterNameDiscoverer", null);
        return this.multiPartResolver.resolveArgument(formParameter, mavContainer, webRequest, binderFactory);
    }

    private void setMethodParameterField(MethodParameter formParameter, String fieldName, Object value) throws IllegalAccessException {
        try {
            Field f = formParameter.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(formParameter, value);
        }
        catch (NoSuchFieldException err) {
            this.logger.warn("Older Spring version? Update to at least 4.3.10.RELEASE, see https://github.com/42BV/beanmapper-spring/issues/19");
        }
    }

    private void validateObject(WebRequestParameters webRequestParameters, Object objectToValidate) throws Exception {
        WebDataBinder binder = webRequestParameters.createBinder(objectToValidate);
        if (objectToValidate != null) {
            this.validateIfApplicable(binder, webRequestParameters.getParameter());
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, webRequestParameters.getParameter())) {
                throw new MethodArgumentNotValidException(webRequestParameters.getParameter(), binder.getBindingResult());
            }
        }
        webRequestParameters.setBindingResult(binder.getBindingResult());
    }

    private Long resolveId(NativeWebRequest webRequest, String mergeId) {
        String mergeIdValue;
        if (StringUtils.isEmpty((CharSequence)mergeId)) {
            return null;
        }
        Map<String, String> uriTemplateVars = this.getUriTemplateVars(webRequest);
        String string = mergeIdValue = uriTemplateVars != null ? uriTemplateVars.get(mergeId) : null;
        if (mergeIdValue == null) {
            mergeIdValue = webRequest.getParameter(mergeId);
        }
        return mergeIdValue != null ? Long.valueOf(mergeIdValue) : null;
    }

    private Map<String, String> getUriTemplateVars(NativeWebRequest webRequest) {
        return (Map)webRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
    }

    private Object getBody(Object form) {
        Object object;
        if (form == null) {
            return null;
        }
        if (form instanceof StructuredBody) {
            StructuredBody structuredBody = (StructuredBody)form;
            object = structuredBody.body();
        } else {
            object = form;
        }
        return object;
    }

    private Set<String> getPropertyNames(Object form) {
        Set<String> set;
        if (form == null) {
            return null;
        }
        if (form instanceof StructuredBody) {
            StructuredBody structuredBody = (StructuredBody)form;
            set = structuredBody.propertyNames();
        } else {
            set = null;
        }
        return set;
    }

    private Object resolveEntity(Object form, Long id, Class<?> entityClass, MergedForm annotation, WebRequestParameters webRequestParameters, boolean mustFlush) throws Exception {
        Object data = this.getBody(form);
        Set<String> propertyNames = this.getPropertyNames(form);
        BeanMapperBuilder customBeanMapperBuilder = this.beanMapper.wrap();
        if (annotation.patch() && propertyNames != null) {
            customBeanMapperBuilder.downsizeSource(new ArrayList<String>(propertyNames));
        }
        if (mustFlush) {
            customBeanMapperBuilder.setFlushEnabled(true);
        }
        BeanMapper customBeanMapper = customBeanMapperBuilder.build();
        MergePair mergePair = new MergePair(customBeanMapper, this.entityFinder, entityClass, annotation);
        if (id == null) {
            mergePair.initNew(data);
        } else {
            mergePair.merge(data, id);
        }
        Object mappedTarget = mergePair.result();
        this.validateObject(webRequestParameters, mappedTarget);
        return mappedTarget;
    }

    private class LazyResolveEntity
    implements Lazy<Object> {
        private final Object form;
        private final Long id;
        private final Class<?> entityClass;
        private final MergedForm annotation;
        private final WebRequestParameters webRequestParameters;

        public LazyResolveEntity(Object form, Long id, Class<?> entityClass, MergedForm annotation, WebRequestParameters webRequestParameters) {
            this.form = form;
            this.id = id;
            this.entityClass = entityClass;
            this.annotation = annotation;
            this.webRequestParameters = webRequestParameters;
        }

        @Override
        public Object get() throws Exception {
            return MergedFormMethodArgumentResolver.this.resolveEntity(this.form, this.id, this.entityClass, this.annotation, this.webRequestParameters, true);
        }
    }
}

