/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.web;

import io.beanmapper.spring.web.EntityFinder;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.support.Repositories;

public class SpringDataEntityFinder
implements EntityFinder {
    private final Repositories repositories;
    private final EntityManager entityManager;

    public SpringDataEntityFinder(ApplicationContext applicationContext, EntityManager entityManager) {
        this.repositories = new Repositories((ListableBeanFactory)applicationContext);
        this.entityManager = entityManager;
    }

    @Override
    public <T> T findAndDetach(Long id, Class<T> entityClass) throws EntityNotFoundException {
        T entity = this.find(id, entityClass);
        this.entityManager.detach(entity);
        return entity;
    }

    @Override
    public <T> T find(Long id, Class<T> entityClass) throws EntityNotFoundException {
        CrudRepository repository = (CrudRepository)this.repositories.getRepositoryFor(entityClass).orElseThrow(() -> new EntityNotFoundException("No repository found for " + entityClass.getName()));
        return repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Entity with ID " + id + "was not found in repository " + repository.getClass().getName()));
    }
}

