/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.web.mockmvc;

import io.beanmapper.BeanMapper;
import io.beanmapper.core.converter.BeanConverter;
import io.beanmapper.spring.web.MergedFormMethodArgumentResolver;
import io.beanmapper.spring.web.mockmvc.MockEntityConverter;
import io.beanmapper.spring.web.mockmvc.MockEntityFinder;
import io.beanmapper.spring.web.mockmvc.MockIdToEntityBeanConverter;
import java.util.List;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;

public class MockMvcBeanMapper {
    private final FormattingConversionService conversionService;
    private final List<HttpMessageConverter<?>> messageConverters;
    private BeanMapper beanMapper;
    private MockEntityFinder mockEntityFinder = new MockEntityFinder();

    public MockMvcBeanMapper(FormattingConversionService conversionService, List<HttpMessageConverter<?>> messageConverters, BeanMapper beanMapper) {
        this.conversionService = conversionService;
        this.messageConverters = messageConverters;
        this.beanMapper = beanMapper.wrap().build();
    }

    public <T extends Persistable<Long>> void registerRepository(CrudRepository<T, Long> repository, Class<T> entityClass) {
        this.conversionService.addConverter(String.class, entityClass, new MockEntityConverter<T>(repository));
        this.beanMapper = this.beanMapper.wrap().addConverter((BeanConverter)new MockIdToEntityBeanConverter(repository, entityClass)).build();
        this.mockEntityFinder.addRepository(repository, entityClass);
    }

    public HandlerMethodArgumentResolver[] createHandlerMethodArgumentResolvers() {
        return new HandlerMethodArgumentResolver[]{new MergedFormMethodArgumentResolver(this.messageConverters, this.beanMapper, this.mockEntityFinder)};
    }

    public FormattingConversionService getConversionService() {
        return this.conversionService;
    }

    public BeanMapper getBeanMapper() {
        return this.beanMapper;
    }
}

