/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.application;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.joda.time.DateTime;
import org.restcomm.connect.application.RvdProjectsMigrationException;
import org.restcomm.connect.application.RvdProjectsMigrationHelper;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.IncomingPhoneNumberFilter;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.email.api.EmailRequest;
import org.restcomm.connect.email.api.Mail;

public class RvdProjectsMigrationHelper {
    private static final String CONTEXT_NAME_RVD = "visual-designer.war";
    private static final String WORKSPACE_DIRECTORY_NAME = "workspace";
    private static final String PROTO_DIRECTORY_PREFIX = "_proto";
    private static final String USERS_DIRECTORY_NAME = "@users";
    private static final Pattern RVD_PROJECT_URL = Pattern.compile("^\\/visual-designer.*\\/(.*)\\/controller$");
    private static final String ACCOUNT_NOTIFICATIONS_SID = "ACae6e420f425248d6a26948c17a9e2acf";
    private static final String EMBEDDED_DIRECTORY_NAME = "workspace-migration";
    private boolean embeddedMigration = false;
    private Configuration configuration;
    private String workspacePath;
    private String workspaceBackupPath;
    private StateHeader currentStateHeader;
    private Application currentApplication;
    private final ApplicationsDao applicationDao;
    private final AccountsDao accountsDao;
    private final IncomingPhoneNumbersDao didsDao;
    private final ClientsDao clientsDao;
    private final NotificationsDao notificationsDao;
    private List<IncomingPhoneNumber> dids;
    private List<Client> clients;
    private ActorRef emailService;
    private ActorSystem system;

    public RvdProjectsMigrationHelper(ServletContext servletContext, Configuration configuration) throws Exception {
        this.defineWorkspacePath(servletContext);
        this.configuration = configuration;
        DaoManager storage = (DaoManager)servletContext.getAttribute(DaoManager.class.getName());
        this.applicationDao = storage.getApplicationsDao();
        this.accountsDao = storage.getAccountsDao();
        this.didsDao = storage.getIncomingPhoneNumbersDao();
        this.clientsDao = storage.getClientsDao();
        this.notificationsDao = storage.getNotificationsDao();
        this.system = (ActorSystem)servletContext.getAttribute(ActorSystem.class.getName());
    }

    private void defineWorkspacePath(ServletContext servletContext) throws Exception {
        String contextRootPath = servletContext.getRealPath("/");
        String contextPathRvd = contextRootPath + "../" + CONTEXT_NAME_RVD + "/";
        File rvd = new File(contextPathRvd);
        if (rvd.exists()) {
            FileInputStream input = new FileInputStream(contextPathRvd + "WEB-INF/rvd.xml");
            XStream xstream = new XStream();
            xstream.alias("rvd", RvdConfig.class);
            RvdConfig rvdConfig = (RvdConfig)xstream.fromXML((InputStream)input);
            String workspaceBasePath = contextPathRvd + WORKSPACE_DIRECTORY_NAME;
            if (rvdConfig.getWorkspaceLocation() != null && !"".equals(rvdConfig.getWorkspaceLocation())) {
                workspaceBasePath = rvdConfig.getWorkspaceLocation().startsWith("/") ? rvdConfig.getWorkspaceLocation() : contextPathRvd + rvdConfig.getWorkspaceLocation();
            }
            this.workspacePath = workspaceBasePath;
            String workspaceBackupBasePath = contextPathRvd;
            if (rvdConfig.getWorkspaceBackupLocation() != null && !"".equals(rvdConfig.getWorkspaceBackupLocation())) {
                workspaceBackupBasePath = rvdConfig.getWorkspaceBackupLocation().startsWith("/") ? rvdConfig.getWorkspaceBackupLocation() : contextPathRvd + rvdConfig.getWorkspaceBackupLocation();
            }
            this.workspaceBackupPath = workspaceBackupBasePath;
        } else {
            String dir = contextRootPath + EMBEDDED_DIRECTORY_NAME + File.separator + WORKSPACE_DIRECTORY_NAME + File.separator;
            File embedded = new File(dir);
            if (embedded.exists()) {
                this.workspacePath = dir;
                this.workspaceBackupPath = contextRootPath;
                this.embeddedMigration = true;
            } else {
                throw new Exception("Error while searching for the workspace location. Aborting migration.");
            }
        }
    }

    public void backupWorkspace() throws RvdProjectsMigrationException {
        try {
            File workspace = new File(this.workspacePath);
            File workspaceBackup = new File(this.workspaceBackupPath + File.separator + "workspaceBackup-" + DateTime.now().getMillis());
            FileUtils.copyDirectoryToDirectory((File)workspace, (File)workspaceBackup);
        }
        catch (IOException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:13] Error while creating backup for RVD workspace", 13);
        }
    }

    public List<String> listProjects() throws RvdProjectsMigrationException {
        ArrayList<String> items = new ArrayList<String>();
        File workspaceDir = new File(this.workspacePath);
        if (workspaceDir.exists()) {
            File[] entries = workspaceDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
            Arrays.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
            for (File entry : entries) {
                items.add(entry.getName());
            }
        } else {
            throw new RvdProjectsMigrationException("[ERROR-CODE:1] Error while loading the list of projects from workspace", 1);
        }
        return items;
    }

    public String searchApplicationSid(String projectName) throws RvdProjectsMigrationException {
        try {
            this.currentApplication = null;
            String applicationSid = null;
            this.currentApplication = this.applicationDao.getApplication(projectName);
            if (this.currentApplication != null) {
                applicationSid = this.currentApplication.getSid().toString();
            } else if (Sid.pattern.matcher(projectName).matches()) {
                Sid sid = new Sid(projectName);
                this.currentApplication = this.applicationDao.getApplication(sid);
                if (this.currentApplication != null) {
                    applicationSid = this.currentApplication.getSid().toString();
                }
            }
            return applicationSid;
        }
        catch (TooManyResultsException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:14] Error while upgrading project '" + projectName + "'. Several applications with such a FriendlyName were found. You have to manually restore this project.", 14);
        }
    }

    public void renameProjectUsingNewConvention(String projectName, String applicationSid) throws RvdProjectsMigrationException {
        try {
            this.renameProject(projectName, applicationSid);
        }
        catch (IOException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:5] Error while renaming the project '" + projectName + "' to '" + applicationSid + "'" + e.getMessage(), 5);
        }
    }

    public void renameProject(String source, String dest) throws IOException {
        File sourceDir = new File(this.workspacePath + File.separator + source);
        File destDir = new File(this.workspacePath + File.separator + dest);
        FileUtils.moveDirectory((File)sourceDir, (File)destDir);
    }

    public void loadProjectState(String projectName) throws RvdProjectsMigrationException {
        try {
            String pathName = this.workspacePath + File.separator + projectName + File.separator + "state";
            File file = new File(pathName);
            if (!file.exists()) {
                throw new RvdProjectsMigrationException("File " + file.getPath() + "does not exist");
            }
            JsonParser parser = new JsonParser();
            String data = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
            JsonElement headerElement = parser.parse(data).getAsJsonObject().get("header");
            if (headerElement == null) {
                throw new RvdProjectsMigrationException();
            }
            Gson gson = new Gson();
            this.currentStateHeader = (StateHeader)gson.fromJson(headerElement, StateHeader.class);
        }
        catch (IOException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:6] Error loading state file from project '" + projectName + "' " + e.getMessage(), 6);
        }
    }

    public boolean projectUsesNewNamingConvention(String projectName) {
        return Sid.pattern.matcher(projectName).matches();
    }

    public String createOrUpdateApplicationEntity(String applicationSid, String projectName) throws RvdProjectsMigrationException {
        try {
            if (applicationSid != null) {
                this.currentApplication = this.currentApplication.setRcmlUrl(URI.create("/visual-designer/services/apps/" + applicationSid + "/controller"));
                this.applicationDao.updateApplication(this.currentApplication);
                return applicationSid;
            }
            Account account = this.accountsDao.getAccount(this.currentStateHeader.getOwner());
            if (account == null) {
                throw new RvdProjectsMigrationException("Error locating the owner account for project \"" + projectName + "\"");
            }
            Application.Builder builder = Application.builder();
            Sid sid = Sid.generate((Sid.Type)Sid.Type.APPLICATION);
            builder.setSid(sid);
            builder.setFriendlyName(projectName);
            builder.setAccountSid(account.getSid());
            builder.setApiVersion(this.configuration.subset("runtime-settings").getString("api-version"));
            builder.setHasVoiceCallerIdLookup(false);
            String rootUri = this.configuration.subset("runtime-settings").getString("root-uri");
            rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
            StringBuilder buffer = new StringBuilder();
            buffer.append(rootUri).append(this.configuration.subset("runtime-settings").getString("api-version")).append("/Accounts/").append(account.getSid().toString()).append("/Applications/").append(sid.toString());
            builder.setUri(URI.create(buffer.toString()));
            builder.setRcmlUrl(URI.create("/visual-designer/services/apps/" + sid.toString() + "/controller"));
            builder.setKind(Application.Kind.getValueOf((String)this.currentStateHeader.getProjectKind()));
            this.currentApplication = builder.build();
            this.applicationDao.addApplication(this.currentApplication);
            return sid.toString();
        }
        catch (RvdProjectsMigrationException e) {
            String suffix = this.currentApplication != null ? "with the application '" + this.currentApplication.getSid().toString() + "' " : "";
            throw new RvdProjectsMigrationException("[ERROR-CODE:7] Error while synchronizing the project '" + projectName + "' " + suffix + e.getMessage(), 7);
        }
    }

    public int updateIncomingPhoneNumbers(String applicationSid, String projectName) throws RvdProjectsMigrationException {
        try {
            if (this.dids == null) {
                IncomingPhoneNumberFilter.Builder filterBuilder = IncomingPhoneNumberFilter.Builder.builder();
                this.dids = this.didsDao.getIncomingPhoneNumbersByFilter(filterBuilder.build());
            }
        }
        catch (Exception e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:8] Error while loading IncomingPhoneNumbers list for updates with project '" + applicationSid + "' " + e.getMessage(), 8);
        }
        Application.Kind kind = Application.Kind.getValueOf((String)this.currentStateHeader.getProjectKind());
        IncomingPhoneNumber did = null;
        int amountUpdated = 0;
        try {
            switch (4.$SwitchMap$org$restcomm$connect$dao$entities$Application$Kind[kind.ordinal()]) {
                case 1: {
                    for (int i = 0; i < this.dids.size(); ++i) {
                        did = (IncomingPhoneNumber)this.dids.get(i);
                        if (!this.hasUrlReference(did.getSmsUrl(), this.currentApplication.getFriendlyName())) continue;
                        Sid smsApplicationSid = new Sid(applicationSid);
                        IncomingPhoneNumber updateSmsDid = new IncomingPhoneNumber(did.getSid(), did.getDateCreated(), did.getDateUpdated(), did.getFriendlyName(), did.getAccountSid(), did.getPhoneNumber(), did.getCost(), did.getApiVersion(), did.hasVoiceCallerIdLookup(), did.getVoiceUrl(), did.getVoiceMethod(), did.getVoiceFallbackUrl(), did.getVoiceFallbackMethod(), did.getStatusCallback(), did.getStatusCallbackMethod(), did.getVoiceApplicationSid(), null, did.getSmsMethod(), did.getSmsFallbackUrl(), did.getSmsFallbackMethod(), smsApplicationSid, did.getUri(), did.getUssdUrl(), did.getUssdMethod(), did.getUssdFallbackUrl(), did.getUssdFallbackMethod(), did.getUssdApplicationSid(), did.getReferUrl(), did.getReferMethod(), did.getReferApplicationSid(), did.isVoiceCapable(), did.isSmsCapable(), did.isMmsCapable(), did.isFaxCapable(), did.isPureSip(), did.getOrganizationSid());
                        this.didsDao.updateIncomingPhoneNumber(updateSmsDid);
                        this.dids.set(i, updateSmsDid);
                        ++amountUpdated;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.dids.size(); ++i) {
                        did = (IncomingPhoneNumber)this.dids.get(i);
                        if (!this.hasUrlReference(did.getUssdUrl(), this.currentApplication.getFriendlyName())) continue;
                        Sid ussdApplicationSid = new Sid(applicationSid);
                        IncomingPhoneNumber updateUssdDid = new IncomingPhoneNumber(did.getSid(), did.getDateCreated(), did.getDateUpdated(), did.getFriendlyName(), did.getAccountSid(), did.getPhoneNumber(), did.getCost(), did.getApiVersion(), did.hasVoiceCallerIdLookup(), did.getVoiceUrl(), did.getVoiceMethod(), did.getVoiceFallbackUrl(), did.getVoiceFallbackMethod(), did.getStatusCallback(), did.getStatusCallbackMethod(), did.getVoiceApplicationSid(), did.getSmsUrl(), did.getSmsMethod(), did.getSmsFallbackUrl(), did.getSmsFallbackMethod(), did.getSmsApplicationSid(), did.getUri(), null, did.getUssdMethod(), did.getUssdFallbackUrl(), did.getUssdFallbackMethod(), ussdApplicationSid, did.getReferUrl(), did.getReferMethod(), did.getReferApplicationSid(), did.isVoiceCapable(), did.isSmsCapable(), did.isMmsCapable(), did.isFaxCapable(), did.isPureSip(), did.getOrganizationSid());
                        this.didsDao.updateIncomingPhoneNumber(updateUssdDid);
                        this.dids.set(i, updateUssdDid);
                        ++amountUpdated;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.dids.size(); ++i) {
                        did = (IncomingPhoneNumber)this.dids.get(i);
                        if (!this.hasUrlReference(did.getVoiceUrl(), this.currentApplication.getFriendlyName())) continue;
                        Sid voiceApplicationSid = new Sid(applicationSid);
                        IncomingPhoneNumber updateVoiceDid = new IncomingPhoneNumber(did.getSid(), did.getDateCreated(), did.getDateUpdated(), did.getFriendlyName(), did.getAccountSid(), did.getPhoneNumber(), did.getCost(), did.getApiVersion(), did.hasVoiceCallerIdLookup(), null, did.getVoiceMethod(), did.getVoiceFallbackUrl(), did.getVoiceFallbackMethod(), did.getStatusCallback(), did.getStatusCallbackMethod(), voiceApplicationSid, did.getSmsUrl(), did.getSmsMethod(), did.getSmsFallbackUrl(), did.getSmsFallbackMethod(), did.getSmsApplicationSid(), did.getUri(), did.getUssdUrl(), did.getUssdMethod(), did.getUssdFallbackUrl(), did.getUssdFallbackMethod(), did.getUssdApplicationSid(), did.getReferUrl(), did.getReferMethod(), did.getReferApplicationSid(), did.isVoiceCapable(), did.isSmsCapable(), did.isMmsCapable(), did.isFaxCapable(), did.isPureSip(), did.getOrganizationSid());
                        this.didsDao.updateIncomingPhoneNumber(updateVoiceDid);
                        this.dids.set(i, updateVoiceDid);
                        ++amountUpdated;
                    }
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:9] Error while updating IncomingPhoneNumber '" + did.getSid().toString() + "' with the Application '" + applicationSid + "' " + e.getMessage(), 9);
        }
        return amountUpdated;
    }

    private boolean hasUrlReference(URI url, String projectName) throws UnsupportedEncodingException {
        Matcher m;
        if (url != null && !url.toString().isEmpty() && (m = RVD_PROJECT_URL.matcher(url.toString())).find()) {
            String result = m.group(1);
            result = URLDecoder.decode(result, "UTF-8");
            return projectName.equals(result);
        }
        return false;
    }

    public int updateClients(String applicationSid, String projectName) throws RvdProjectsMigrationException {
        try {
            if (this.clients == null) {
                this.clients = this.clientsDao.getAllClients();
            }
        }
        catch (Exception e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:10] Error while loading the Clients list for updates with project '" + applicationSid + "'. " + e.getMessage(), 10);
        }
        Application.Kind kind = Application.Kind.getValueOf((String)this.currentStateHeader.getProjectKind());
        Client client = null;
        int amountUpdated = 0;
        try {
            if (kind == Application.Kind.VOICE) {
                for (int i = 0; i < this.clients.size(); ++i) {
                    client = (Client)this.clients.get(i);
                    if (!this.hasUrlReference(client.getVoiceUrl(), this.currentApplication.getFriendlyName())) continue;
                    Sid voiceApplicationSid = new Sid(applicationSid);
                    client = client.setVoiceApplicationSid(voiceApplicationSid);
                    client = client.setVoiceUrl(null);
                    this.clientsDao.updateClient(client);
                    this.clients.set(i, client);
                    ++amountUpdated;
                }
            }
        }
        catch (Exception e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:11] Error while updating Client '" + client.getSid().toString() + "' with the Application '" + applicationSid + "' " + e.getMessage(), 11);
        }
        return amountUpdated;
    }

    public void storeWorkspaceStatus(boolean migrationSucceeded) throws RvdProjectsMigrationException {
        String pathName = this.workspacePath + File.separator + ".version";
        File file = new File(pathName);
        Gson gson = new Gson();
        String version = org.restcomm.connect.commons.Version.getVersion();
        Version ws = new Version(this, migrationSucceeded, version);
        String data = gson.toJson((Object)ws);
        try {
            FileUtils.writeStringToFile((File)file, (String)data, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RvdProjectsMigrationException("[ERROR-CODE:12] Error creating file in storage: " + file + e.getMessage(), 12);
        }
    }

    public boolean isMigrationExecuted() {
        String data;
        String pathName = this.workspacePath + File.separator + ".version";
        File file = new File(pathName);
        if (!file.exists()) {
            return false;
        }
        try {
            data = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonObject element = parser.parse(data).getAsJsonObject();
        if (element != null) {
            Gson gson = new Gson();
            Version workspaceVersion = (Version)gson.fromJson((JsonElement)element, Version.class);
            String restcommVersion = org.restcomm.connect.commons.Version.getVersion();
            return workspaceVersion.getVersion().equals(restcommVersion) || workspaceVersion.getStatus();
        }
        return false;
    }

    public void addNotification(String message, boolean error, Integer errorCode) throws URISyntaxException {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(new Sid(ACCOUNT_NOTIFICATIONS_SID));
        builder.setApiVersion(this.configuration.subset("runtime-settings").getString("api-version"));
        builder.setLog((error ? new Integer(1) : new Integer(0)).intValue());
        builder.setErrorCode(errorCode.intValue());
        builder.setMoreInfo(new URI("http://docs.telestax.com/rvd-workspace-upgrade"));
        builder.setMessageText(message);
        builder.setMessageDate(DateTime.now());
        builder.setRequestUrl(new URI(""));
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.configuration.subset("runtime-settings").getString("api-version")).append("/Accounts/");
        buffer.append(ACCOUNT_NOTIFICATIONS_SID).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        Notification notification = builder.build();
        this.notificationsDao.addNotification(notification);
    }

    public boolean isMigrationEnabled() {
        Boolean value = new Boolean(this.configuration.subset("runtime-settings").getString("rvd-workspace-migration-enabled", "true"));
        return value;
    }

    public void sendEmailNotification(String message, boolean migrationSucceeded) throws RvdProjectsMigrationException {
        String host = this.configuration.subset("smtp-notify").getString("host");
        String username = this.configuration.subset("smtp-notify").getString("user");
        String password = this.configuration.subset("smtp-notify").getString("password");
        String defaultEmailAddress = this.configuration.subset("smtp-notify").getString("default-email-address");
        if (host == null || username == null || password == null || defaultEmailAddress == null || host.isEmpty() || username.isEmpty() || password.isEmpty() || defaultEmailAddress.isEmpty()) {
            throw new RvdProjectsMigrationException("Skipping email notification due to invalid configuration");
        }
        if (this.emailService == null) {
            this.emailService = this.emailService(this.configuration.subset("smtp-notify"));
        }
        String subject = "Restcomm - RVD Projects migration";
        String body = message;
        if (!migrationSucceeded) {
            body = body + ". Please, visit http://docs.telestax.com/rvd-workspace-upgrade for more information on how to troubleshoot workspace migration issues.";
        }
        Mail emailMsg = new Mail(username + "@" + host, defaultEmailAddress, subject, body);
        this.emailService.tell((Object)new EmailRequest(emailMsg), this.emailService);
    }

    private ActorRef emailService(Configuration configuration) {
        Props props = new Props((UntypedActorFactory)new /* Unavailable Anonymous Inner Class!! */);
        return this.system.actorOf(props);
    }

    public boolean isEmbeddedMigration() {
        return this.embeddedMigration;
    }
}

