/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.email;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.email.api.EmailRequest;
import org.restcomm.connect.email.api.EmailResponse;
import org.restcomm.connect.email.api.Mail;

public class EmailService
extends RestcommUntypedActor {
    final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final List<ActorRef> observers;
    private Configuration configuration;
    private Session session;
    private String host;
    private String port;
    private String user;
    private String password;
    private Transport transport;
    private final Properties properties = System.getProperties();
    private boolean isSslEnabled = false;

    public EmailService(Configuration config) {
        this.observers = new ArrayList<ActorRef>();
        this.configuration = config;
        this.host = this.configuration.getString("host");
        this.port = this.configuration.getString("port");
        this.user = this.configuration.getString("user");
        this.password = this.configuration.getString("password");
        if (this.user != null && !this.user.isEmpty() || this.password != null && !this.password.isEmpty() || this.port != null && !this.port.isEmpty() || this.host != null && !this.host.isEmpty()) {
            if ("465".equals(this.port)) {
                this.isSslEnabled = true;
                this.useSSLSmtp();
            } else {
                this.properties.setProperty("mail.smtp.host", this.host);
                this.properties.setProperty("mail.smtp.user", this.user);
                this.properties.setProperty("mail.smtp.password", this.password);
                this.properties.setProperty("mail.smtp.port", this.port);
            }
            this.properties.setProperty("mail.smtp.starttls.enable", "true");
            this.properties.setProperty("mail.transport.protocol", "smtps");
            this.properties.setProperty("mail.smtp.auth", "true");
            this.session = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailService.this.user, EmailService.this.password);
                }
            });
        }
    }

    private void useSSLSmtp() {
        this.properties.put("mail.transport.protocol", "smtps");
        this.properties.put("mail.smtps.ssl.enable", "true");
        this.properties.put("mail.smtps.host", this.host);
        this.properties.put("mail.smtps.user", this.user);
        this.properties.put("mail.smtps.password", this.password);
        this.properties.put("mail.smtps.port", this.port);
        this.properties.put("mail.smtps.auth", "true");
        this.session = Session.getDefaultInstance((Properties)this.properties);
        try {
            this.transport = this.session.getTransport();
        }
        catch (NoSuchProviderException ex) {
            this.logger.error(EmailService.class.getName(), (Object)ex);
        }
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (EmailRequest.class.equals(klass)) {
            EmailRequest request = (EmailRequest)message;
            if (this.isSslEnabled) {
                sender.tell((Object)this.sendEmailSsL(request.getObject()), self);
            } else {
                sender.tell((Object)this.send(request.getObject()), self);
            }
        }
    }

    EmailResponse sendEmailSsL(Mail mail) {
        try {
            InternetAddress from = mail.from() != null || !mail.from().equalsIgnoreCase("") ? new InternetAddress(mail.from()) : new InternetAddress(this.user);
            InternetAddress to = new InternetAddress(mail.to());
            MimeMessage email = new MimeMessage(this.session);
            email.setFrom((Address)from);
            email.addRecipient(Message.RecipientType.TO, (Address)to);
            email.setSubject(mail.subject());
            email.setContent((Object)mail.body(), mail.contentType());
            email.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)mail.cc(), (boolean)false));
            email.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)mail.bcc(), (boolean)false));
            this.transport.connect(this.host, Integer.parseInt(this.port), this.user, this.password);
            this.transport.sendMessage((Message)email, email.getRecipients(Message.RecipientType.TO));
            return new EmailResponse((Object)mail);
        }
        catch (MessagingException exception) {
            this.logger.error(exception.getMessage(), (Object)exception);
            return new EmailResponse((Throwable)exception, exception.getMessage());
        }
    }

    EmailResponse send(Mail mail) {
        try {
            InternetAddress from = mail.from() != null || !mail.from().equalsIgnoreCase("") ? new InternetAddress(mail.from()) : new InternetAddress(this.user);
            InternetAddress to = new InternetAddress(mail.to());
            MimeMessage email = new MimeMessage(this.session);
            email.setFrom((Address)from);
            email.addRecipient(Message.RecipientType.TO, (Address)to);
            email.setSubject(mail.subject());
            email.setContent((Object)mail.body(), mail.contentType());
            email.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)mail.cc(), (boolean)false));
            email.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)mail.bcc(), (boolean)false));
            Transport.send((Message)email);
            return new EmailResponse((Object)mail);
        }
        catch (MessagingException exception) {
            this.logger.error(exception.getMessage(), (Object)exception);
            return new EmailResponse((Throwable)exception, exception.getMessage());
        }
    }
}

