/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.aspect;

import com.github.f4b6a3.uuid.UuidCreator;
import io.bitdive.parent.message_producer.MessageService;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.DataUtils;
import io.bitdive.parent.trasirovka.agent.utils.ReflectionUtils;
import io.bitdive.parent.utils.MethodTypeEnum;
import java.time.OffsetDateTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FeignClientAspect {
    @Around(value="@within(org.springframework.cloud.openfeign.FeignClient)")
    public Object aroundFeignClientMethods(ProceedingJoinPoint joinPoint) throws Throwable {
        String UUIDMessage = UuidCreator.getTimeBased().toString();
        Object retVal = null;
        Throwable thrown = null;
        MethodSignature methodSig = (MethodSignature)joinPoint.getSignature();
        try {
            MessageService.sendMessageStart(YamlParserConfig.getProfilingConfig().getApplication().getModuleName(), YamlParserConfig.getProfilingConfig().getApplication().getServiceName(), UUIDMessage, methodSig.getDeclaringTypeName(), methodSig.getName(), ContextManager.getTraceId(), ContextManager.getSpanId(), OffsetDateTime.now(), ContextManager.getParentIdMessageIdQueue(), false, ReflectionUtils.objectToString(DataUtils.paramConvert(joinPoint.getArgs())), MethodTypeEnum.METHOD.toString(), "");
            ContextManager.setMethodCallContextQueue(UUIDMessage);
            retVal = joinPoint.proceed();
        }
        catch (Throwable t) {
            try {
                thrown = t;
                throw t;
            }
            catch (Throwable throwable) {
                MessageService.sendMessageEnd(UUIDMessage, OffsetDateTime.now(), DataUtils.getaNullThrowable(thrown), ReflectionUtils.objectToString(DataUtils.methodReturnConvert(retVal)), ContextManager.getTraceId(), ContextManager.getSpanId());
                ContextManager.removeLastQueue();
                throw throwable;
            }
        }
        MessageService.sendMessageEnd(UUIDMessage, OffsetDateTime.now(), DataUtils.getaNullThrowable(thrown), ReflectionUtils.objectToString(DataUtils.methodReturnConvert(retVal)), ContextManager.getTraceId(), ContextManager.getSpanId());
        ContextManager.removeLastQueue();
        return retVal;
    }
}

