/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.jvm_metrics;

import io.bitdive.parent.jvm_metrics.MetricsService;
import io.bitdive.parent.parserConfig.ProfilingConfig;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.utils.UtilsDataConvert;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class GenerateJvmMetrics {
    private static ScheduledExecutorService scheduler;
    private static Path logDirectoryPath;
    private static DateTimeFormatter formatter;
    private static Proxy proxy;
    private static MeterRegistry meterRegistry;

    public static void init() {
        block4: {
            String filePath = YamlParserConfig.getProfilingConfig().getMonitoring().getDataFile().getPath() + File.separator + "toSendMetrics";
            scheduler = Executors.newSingleThreadScheduledExecutor();
            logDirectoryPath = Paths.get(filePath, new String[0]);
            formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
            String proxyHost = Optional.ofNullable(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer()).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig::getProxy).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig.ProxyConfig::getHost).orElse(null);
            String proxyPort = Optional.ofNullable(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer()).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig::getProxy).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig.ProxyConfig::getPort).map(Object::toString).orElse(null);
            String proxyUserName = Optional.ofNullable(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer()).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig::getProxy).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig.ProxyConfig::getUsername).orElse(null);
            String proxyPassword = Optional.ofNullable(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer()).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig::getProxy).map(ProfilingConfig.MonitoringConfig.MonitoringSendFilesConfig.ServerConsumerConfig.ProxyConfig::getPassword).orElse(null);
            proxy = UtilsDataConvert.initilizationProxy(proxyHost, proxyPort, proxyUserName, proxyPassword);
            try {
                if (!Files.exists(logDirectoryPath, new LinkOption[0])) {
                    Files.createDirectories(logDirectoryPath, new FileAttribute[0]);
                    if (LoggerStatusContent.isDebug()) {
                        System.out.println("A directory for logs has been created: " + logDirectoryPath.toAbsolutePath());
                    }
                }
            }
            catch (IOException e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block4;
                System.err.println("Failed to create log directory: " + filePath + " \n Error: " + e);
            }
        }
        GenerateJvmMetrics.startLogging();
    }

    private static void startLogging() {
        block2: {
            try {
                meterRegistry = new SimpleMeterRegistry();
                new JvmMemoryMetrics().bindTo(meterRegistry);
                new JvmGcMetrics().bindTo(meterRegistry);
                new JvmThreadMetrics().bindTo(meterRegistry);
                new ProcessorMetrics().bindTo(meterRegistry);
                new UptimeMetrics().bindTo(meterRegistry);
                new FileDescriptorMetrics().bindTo(meterRegistry);
                meterRegistry.counter("bitDive.metrics", new String[0]).increment(5.0);
                Runnable logTask = GenerateJvmMetrics::collectMetrics;
                scheduler.scheduleAtFixedRate(logTask, 0L, 30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.out.println("Start logging metrics every minute to a directory: " + logDirectoryPath.toAbsolutePath());
            }
        }
    }

    public void stopLogging() {
        block4: {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
                if (LoggerStatusContent.isDebug()) {
                    System.out.println("Metric logging has stopped.");
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                if (!LoggerStatusContent.isErrorsOrDebug()) break block4;
                System.err.println("Metrics logging was interrupted.");
            }
        }
    }

    private static void collectMetrics() {
        block2: {
            try {
                GenerateJvmMetrics.writeMetricsToFile(new MetricsService(meterRegistry));
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("Failed to write metrics to file: " + e.getMessage());
            }
        }
    }

    private static void writeMetricsToFile(MetricsService metricsService) {
        block2: {
            try {
                String timestamp = LocalDateTime.now().format(formatter);
                String fileName = String.format("jvm_metrics_%s.BitDiveData", timestamp);
                Path filePath = logDirectoryPath.resolve(fileName);
                Files.write(filePath, metricsService.sendMetrics().getBytes(), StandardOpenOption.CREATE_NEW);
                GenerateJvmMetrics.scanAndSendFiles();
            }
            catch (IOException e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("Failed to write metrics to file: " + e.getMessage());
            }
        }
    }

    private static void scanAndSendFiles() {
        block18: {
            try {
                ArrayList<Path> filesToSend = new ArrayList<Path>();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(logDirectoryPath, "*.BitDiveData");){
                    for (Path entry : stream) {
                        filesToSend.add(entry);
                    }
                }
                for (Path file : filesToSend) {
                    boolean success = UtilsDataConvert.sendFile(file.toFile(), proxy, "uploadFileJVMMetrics");
                    if (success) {
                        Files.delete(file);
                        continue;
                    }
                    BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime creationTime = attrs.creationTime();
                    long ageInMinutes = (System.currentTimeMillis() - creationTime.toMillis()) / 60000L;
                    if (ageInMinutes <= (long)YamlParserConfig.getProfilingConfig().getMonitoring().getDataFile().getFileStorageTime().intValue()) continue;
                    Files.delete(file);
                }
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isDebug()) break block18;
                System.out.println("error scan file " + e);
            }
        }
    }
}

