/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.jvm_metrics;

import io.bitdive.parent.jvm_metrics.MeasurementDto;
import io.bitdive.parent.jvm_metrics.MetricDto;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public class MetricsCollector {
    private String moduleName;
    private String serviceName;
    private OffsetDateTime createdMetric;
    private String serviceNodeUUID;
    private List<MetricDto> listOfMetrics;

    public MetricsCollector(MeterRegistry meterRegistry) {
        this.listOfMetrics = this.collectMetrics(meterRegistry);
    }

    private List<MetricDto> collectMetrics(MeterRegistry meterRegistry) {
        ArrayList<MetricDto> metricsDtoList = new ArrayList<MetricDto>();
        for (Meter meter : meterRegistry.getMeters()) {
            MetricDto dto = new MetricDto();
            dto.setName(meter.getId().getName());
            for (Measurement measurement : meter.measure()) {
                String statistic = measurement.getStatistic().name();
                double value = measurement.getValue();
                dto.getMeasurements().add(new MeasurementDto(statistic, value));
            }
            metricsDtoList.add(dto);
        }
        return metricsDtoList;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setCreatedMetric(OffsetDateTime createdMetric) {
        this.createdMetric = createdMetric;
    }

    public void setServiceNodeUUID(String serviceNodeUUID) {
        this.serviceNodeUUID = serviceNodeUUID;
    }

    public void setListOfMetrics(List<MetricDto> listOfMetrics) {
        this.listOfMetrics = listOfMetrics;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public OffsetDateTime getCreatedMetric() {
        return this.createdMetric;
    }

    public String getServiceNodeUUID() {
        return this.serviceNodeUUID;
    }

    public List<MetricDto> getListOfMetrics() {
        return this.listOfMetrics;
    }
}

