/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.jvm_metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.bitdive.parent.jvm_metrics.MetricsCollector;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class MetricsService {
    private MetricsCollector metricsCollector;
    private static final Gson mapper = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (src, typeOfSrc, context) -> context.serialize((Object)src.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME))).registerTypeAdapter(OffsetDateTime.class, (json, type, context) -> OffsetDateTime.parse(json.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME)).create();

    public MetricsService(MeterRegistry meterRegistry) {
        block2: {
            try {
                this.metricsCollector = new MetricsCollector(meterRegistry);
                this.metricsCollector.setModuleName(YamlParserConfig.getProfilingConfig().getApplication().getModuleName());
                this.metricsCollector.setServiceName(YamlParserConfig.getProfilingConfig().getApplication().getServiceName());
                this.metricsCollector.setCreatedMetric(OffsetDateTime.now());
                this.metricsCollector.setServiceNodeUUID(YamlParserConfig.getUUIDService());
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("Failed to write metrics to file: " + e.getMessage());
            }
        }
    }

    public String sendMetrics() {
        try {
            return mapper.toJson((Object)this.metricsCollector);
        }
        catch (Exception e) {
            System.out.println("Error while sending metrics: " + e.getMessage());
            return "";
        }
    }
}

