/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.message_producer;

import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.utils.UtilsDataConvert;
import java.io.IOException;
import java.io.Serializable;
import java.net.Proxy;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="CustomHttpAppender", category="Core", elementType="appender")
public class CustomHttpAppender
extends AbstractAppender {
    private final String url;
    private final String filePath;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean isSending;
    private final Proxy proxy;
    private final Integer fileStorageTime;

    protected CustomHttpAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String url, Proxy proxy, long scanIntervalSeconds, Configuration configuration, String filePath, Integer fileStorageTime) {
        super(name, filter, layout, ignoreExceptions);
        this.url = url;
        this.fileStorageTime = fileStorageTime;
        this.isSending = new AtomicBoolean(false);
        this.proxy = proxy;
        this.filePath = filePath;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(this::scanAndSendFiles, 0L, scanIntervalSeconds, TimeUnit.SECONDS);
    }

    @PluginFactory
    public static CustomHttpAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter, @PluginAttribute(value="url") String url, @PluginAttribute(value="proxyHost") String proxyHost, @PluginAttribute(value="proxyPort") String proxyPort, @PluginAttribute(value="proxyUserName") String proxyUserName, @PluginAttribute(value="proxyPassword") String proxyPassword, @PluginAttribute(value="filePath") String filePath, @PluginAttribute(value="scanIntervalSeconds") String scanIntervalSecondsStr, @PluginAttribute(value="fileStorageTime") Integer fileStorageTime, @PluginConfiguration Configuration configuration) {
        Proxy proxy = UtilsDataConvert.initilizationProxy(proxyHost, proxyPort, proxyUserName, proxyPassword);
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        long scanIntervalSeconds = 10L;
        if (scanIntervalSecondsStr != null) {
            scanIntervalSeconds = Long.parseLong(scanIntervalSecondsStr);
        }
        return new CustomHttpAppender(name, filter, (Layout<? extends Serializable>)layout, true, url, proxy, scanIntervalSeconds, configuration, filePath, fileStorageTime);
    }

    public void append(LogEvent event) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isGzipValid(Path file) {
        try (GZIPInputStream gis = new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]));){
            byte[] buffer = new byte[8192];
            while (gis.read(buffer) != -1) {
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (!LoggerStatusContent.isDebug()) return false;
            System.out.println("Integrity check failed for file " + file + ": " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanAndSendFiles() {
        if (this.isSending.compareAndSet(false, true)) {
            try {
                Path dir = Paths.get(this.filePath, new String[0]);
                ArrayList<Path> filesToSend = new ArrayList<Path>();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.gz");){
                    for (Path entry : stream) {
                        filesToSend.add(entry);
                    }
                }
                for (Path file : filesToSend) {
                    if (!this.isGzipValid(file)) continue;
                    boolean success = UtilsDataConvert.sendFile(file.toFile(), this.proxy, "uploadFileData");
                    if (success) {
                        Files.delete(file);
                        continue;
                    }
                    BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime creationTime = attrs.creationTime();
                    long ageInMinutes = (System.currentTimeMillis() - creationTime.toMillis()) / 60000L;
                    if (ageInMinutes <= (long)this.fileStorageTime.intValue()) continue;
                    Files.delete(file);
                }
            }
            catch (Exception e) {
                if (LoggerStatusContent.isDebug()) {
                    System.out.println("error scan file " + e);
                }
            }
            finally {
                this.isSending.set(false);
            }
        }
    }

    public void stop() {
        super.stop();
        try {
            this.scheduler.shutdown();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

