/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.message_producer;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class PemUtils {
    public static PrivateKey getPrivateKeyFromPEM(String pem) {
        PrivateKeyInfo pkInfo;
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pem));
        Object object = pemParser.readObject();
        pemParser.close();
        if (object instanceof PEMKeyPair) {
            pkInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
        } else if (object instanceof PrivateKeyInfo) {
            pkInfo = (PrivateKeyInfo)object;
        } else if (object instanceof ECPrivateKey) {
            ECPrivateKey ecPrivateKey = (ECPrivateKey)object;
            pkInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey), (ASN1Encodable)ecPrivateKey);
        } else {
            throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f PEM-\u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + object.getClass().getName());
        }
        byte[] pkcs8Bytes = pkInfo.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Bytes);
        KeyFactory kf = KeyFactory.getInstance("EC", "BC");
        return kf.generatePrivate(keySpec);
    }
}

