/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.safety_config;

import io.bitdive.parent.safety_config.VaultGettingConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;

public class SSLContextCustomBitDive {
    private static SSLContext sslContext;
    private static X509Certificate clientCertificate;

    private static void loadCertificatesAndInitializeSSLContext() throws Exception {
        VaultGettingConfig.VaultConfigRet vaultConfigSer = VaultGettingConfig.retrieveCertificatesFromVault();
        clientCertificate = SSLContextCustomBitDive.loadCertificate(vaultConfigSer.getCertificate());
        PrivateKey clientPrivateKey = SSLContextCustomBitDive.loadPrivateKey(vaultConfigSer.getPrivateKey());
        List<X509Certificate> caCertificates = SSLContextCustomBitDive.loadCACertificates(vaultConfigSer.getCaChain());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        Certificate[] certificateChain = new X509Certificate[caCertificates.size() + 1];
        certificateChain[0] = clientCertificate;
        for (int i = 0; i < caCertificates.size(); ++i) {
            certificateChain[i + 1] = caCertificates.get(i);
        }
        keyStore.setKeyEntry("client", clientPrivateKey, "changeit".toCharArray(), certificateChain);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        int index = 0;
        for (X509Certificate caCert : caCertificates) {
            trustStore.setCertificateEntry("ca-cert-" + index, caCert);
            ++index;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, "changeit".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
    }

    public static void ensureValidCertificate() throws Exception {
        if (!SSLContextCustomBitDive.isCertificateValid()) {
            VaultGettingConfig.initVaultConnect();
            SSLContextCustomBitDive.loadCertificatesAndInitializeSSLContext();
        }
    }

    private static boolean isCertificateValid() {
        try {
            clientCertificate.checkValidity();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PrivateKey loadPrivateKey(String pem) throws IOException, OperatorCreationException {
        PrivateKey privateKey;
        StringReader reader = new StringReader(pem);
        PEMParser pemParser = new PEMParser((Reader)reader);
        Object object = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        if (object instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)object;
            PEMKeyPair keyPair = encryptedKeyPair.decryptKeyPair(new JcePEMDecryptorProviderBuilder().build("password".toCharArray()));
            privateKey = converter.getPrivateKey(keyPair.getPrivateKeyInfo());
        } else if (object instanceof PEMKeyPair) {
            PEMKeyPair keyPair = (PEMKeyPair)object;
            privateKey = converter.getPrivateKey(keyPair.getPrivateKeyInfo());
        } else if (object instanceof PrivateKeyInfo) {
            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
            privateKey = converter.getPrivateKey(privateKeyInfo);
        } else if (object instanceof RSAPrivateKey) {
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)object;
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)rsaPrivateKey);
            privateKey = converter.getPrivateKey(privateKeyInfo);
        } else {
            throw new IllegalArgumentException("Invalid key format");
        }
        return privateKey;
    }

    private static X509Certificate loadCertificate(String certificatePEM) throws Exception {
        String certificateContent = certificatePEM.trim();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateContent.getBytes(StandardCharsets.UTF_8));
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }

    private static List<X509Certificate> loadCACertificates(String caChainPEM) throws Exception {
        String[] certificates;
        ArrayList<X509Certificate> caCertificates = new ArrayList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (String cert : certificates = caChainPEM.split("(?=-----BEGIN CERTIFICATE-----)")) {
            if ((cert = cert.trim()).isEmpty()) continue;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8));
            X509Certificate caCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            caCertificates.add(caCert);
        }
        return caCertificates;
    }

    public static SSLContext getSslContext() {
        return sslContext;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

