/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.safety_config;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.JsonValue;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import io.bitdive.parent.message_producer.LocalCryptoService;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class VaultGettingConfig {
    private static final String ENCRYPTION_KEY_PATH = "transit/export/encryption-key/encryption-key";
    private static final String SIGNING_KEY_PATH = "transit/export/signing-key/signing-key";
    private static Vault vault;
    private static final ScheduledExecutorService scheduler;

    public static void initVaultConnect() {
        try {
            VaultConfig config = null;
            try {
                config = new VaultConfig().address(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().getVault().getUrl()).sslConfig(new SslConfig().verify(Boolean.valueOf(false)).build()).engineVersion(Integer.valueOf(1)).build();
            }
            catch (VaultException e) {
                throw new RuntimeException(e);
            }
            vault = new Vault(config);
            AuthResponse authResponse = vault.auth().loginByUserPass(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().getVault().getLogin(), YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().getVault().getPassword());
            String clientToken = authResponse.getAuthClientToken();
            config.token(clientToken).build();
            VaultGettingConfig.updateAESKey();
            VaultGettingConfig.updateRSAPrivateKey();
            VaultGettingConfig.startKeyUpdates();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startKeyUpdates() {
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        VaultGettingConfig.updateAESKey();
                        VaultGettingConfig.updateRSAPrivateKey();
                        if (LoggerStatusContent.isDebug()) {
                            System.out.println("keys were successfully updated in " + LocalDateTime.now());
                        }
                    }
                    catch (Exception e) {
                        if (!LoggerStatusContent.isDebug()) break block3;
                        System.out.println("error successfully updated :" + e.getMessage());
                    }
                }
            }
        };
        scheduler.scheduleAtFixedRate(updateTask, 0L, 1L, TimeUnit.HOURS);
    }

    public static VaultConfigRet retrieveCertificatesFromVault() throws Exception {
        final URL url = new URL(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().getUrl());
        LogicalResponse response = vault.withRetries(5, 1000).logical().write("pki/issue/bitdive", (Map)new HashMap<String, Object>(){
            {
                this.put("common_name", "file-acceptor.bitdive");
                this.put("alt_names", url.getHost());
                this.put("ttl", "24h");
            }
        });
        return VaultConfigRet.builder().certificate((String)response.getData().get("certificate")).privateKey((String)response.getData().get("private_key")).caChain((String)response.getData().get("issuing_ca")).build();
    }

    public static Stream<JsonValue> iteratorToStream(Iterator<JsonValue> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false);
    }

    private static void updateAESKey() throws VaultException {
        LogicalResponse response = vault.logical().read(ENCRYPTION_KEY_PATH);
        Integer maxKeyId = response.getDataObject().get("keys").asObject().names().stream().map(Integer::parseInt).max(Integer::compareTo).orElse(null);
        LocalCryptoService.addKeySecretKey(maxKeyId, response.getDataObject().get("keys").asObject().get(String.valueOf(maxKeyId)).asString());
    }

    private static void updateRSAPrivateKey() throws Exception {
        LogicalResponse response = vault.logical().read(SIGNING_KEY_PATH);
        Integer maxKeyId = response.getDataObject().get("keys").asObject().names().stream().map(Integer::parseInt).max(Integer::compareTo).orElse(null);
        LocalCryptoService.addKeyPrivateKey(maxKeyId, response.getDataObject().get("keys").asObject().get(String.valueOf(maxKeyId)).asString());
    }

    static {
        scheduler = Executors.newScheduledThreadPool(1);
    }

    public static class VaultConfigRet {
        private String certificate;
        private String privateKey;
        private String caChain;

        VaultConfigRet(String certificate, String privateKey, String caChain) {
            this.certificate = certificate;
            this.privateKey = privateKey;
            this.caChain = caChain;
        }

        public static VaultConfigRetBuilder builder() {
            return new VaultConfigRetBuilder();
        }

        public String getCertificate() {
            return this.certificate;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getCaChain() {
            return this.caChain;
        }

        public static class VaultConfigRetBuilder {
            private String certificate;
            private String privateKey;
            private String caChain;

            VaultConfigRetBuilder() {
            }

            public VaultConfigRetBuilder certificate(String certificate) {
                this.certificate = certificate;
                return this;
            }

            public VaultConfigRetBuilder privateKey(String privateKey) {
                this.privateKey = privateKey;
                return this;
            }

            public VaultConfigRetBuilder caChain(String caChain) {
                this.caChain = caChain;
                return this;
            }

            public VaultConfigRet build() {
                return new VaultConfigRet(this.certificate, this.privateKey, this.caChain);
            }

            public String toString() {
                return "VaultGettingConfig.VaultConfigRet.VaultConfigRetBuilder(certificate=" + this.certificate + ", privateKey=" + this.privateKey + ", caChain=" + this.caChain + ")";
            }
        }
    }
}

