/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import com.github.f4b6a3.uuid.UuidCreator;
import io.bitdive.parent.message_producer.MessageService;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.DataUtils;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.trasirovka.agent.utils.ReflectionUtils;
import io.bitdive.parent.utils.MethodTypeEnum;
import io.bitdive.parent.utils.Pair;
import io.bitdive.parent.utils.UtilsDataConvert;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.concurrent.CompletableFuture;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddyAgentBasic {
    public static ElementMatcher.Junction<TypeDescription> getSpringComponentMatcher() {
        boolean monitoringOnlySpringComponent = YamlParserConfig.getProfilingConfig().getMonitoring().getMonitoringOnlySpringComponent();
        if (monitoringOnlySpringComponent) {
            return ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.nameContains((String)"org.springframework"));
        }
        return ElementMatchers.any();
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> getApplicationPackedScanner(String[] infixes) {
        ElementMatcher.Junction matcher = ElementMatchers.none();
        for (String infix : infixes) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.nameStartsWith((String)infix));
        }
        return matcher;
    }

    private static ElementMatcher.Junction<TypeDescription> getExcludedSuperTypeMatcher() {
        String[] excludedPackages = new String[]{"org.springframework.security.", "org.springframework.web.filter."};
        ElementMatcher.Junction matcher = ElementMatchers.none();
        for (String pkg : excludedPackages) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.nameStartsWith((String)pkg)));
        }
        return matcher;
    }

    public static void init() {
        new AgentBuilder.Default().type((ElementMatcher)ByteBuddyAgentBasic.getApplicationPackedScanner(YamlParserConfig.getProfilingConfig().getApplication().getPackedScanner()).and(ByteBuddyAgentBasic.getSpringComponentMatcher()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isEnum())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"io.bitdive.parent.anotations.NotMonitoring")))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameEndsWith((String)"Configuration"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameEndsWith((String)"RefreshScope"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameEndsWith((String)"ConfigurationProperties"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isSynthetic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameMatches((String)".*\\$\\$.*"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameContains((String)"CGLIB"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameContains((String)"ByteBuddy"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameContains((String)"$"))).and((ElementMatcher)ElementMatchers.not(ByteBuddyAgentBasic.getExcludedSuperTypeMatcher()))).transform((builder, typeDescription, classLoader, module, sd) -> builder.method((ElementMatcher)ElementMatchers.any().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.nameEndsWith((String)"Bean")))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.nameEndsWith((String)"ExceptionHandler")))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"org.springframework.scheduling.annotation.Scheduled")))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameMatches((String)".*\\$.*"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isSynthetic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Enum.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.nameEndsWith((String)"PostConstruct"))))).intercept((Implementation)Advice.to(BasicInterceptor.class))).installOnByteBuddyAgent();
    }

    public static class BasicInterceptor {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Origin Method method, @Advice.AllArguments Object[] args) {
            block7: {
                try {
                    if (!YamlParserConfig.getProfilingConfig().getMonitoring().getMonitoringStaticMethod().booleanValue() && UtilsDataConvert.isStaticMethod(method).booleanValue()) {
                        return;
                    }
                    if (UtilsDataConvert.isSerializationContext()) {
                        return;
                    }
                    Pair<MethodTypeEnum, Boolean> flagNewSpan = UtilsDataConvert.identificationMethod(method);
                    if (!flagNewSpan.getVal().booleanValue() && ContextManager.isMessageIdQueueEmpty()) {
                        return;
                    }
                    String UUIDMessage = null;
                    String urlVal = "";
                    if (flagNewSpan.getVal().booleanValue() && flagNewSpan.getKey() != MethodTypeEnum.METHOD && flagNewSpan.getKey() != MethodTypeEnum.SCHEDULER && ContextManager.isMessageIdQueueEmpty()) {
                        UUIDMessage = ContextManager.getMessageStart();
                        urlVal = ContextManager.getUrlStart();
                    } else {
                        UUIDMessage = UuidCreator.getTimeBased().toString();
                    }
                    MessageService.sendMessageStart(YamlParserConfig.getProfilingConfig().getApplication().getModuleName(), YamlParserConfig.getProfilingConfig().getApplication().getServiceName(), UUIDMessage, method.getDeclaringClass().getName(), method.getName(), ContextManager.getTraceId(), ContextManager.getSpanId(), OffsetDateTime.now(), ContextManager.getParentIdMessageIdQueue(), flagNewSpan.getVal(), ReflectionUtils.objectToString(DataUtils.paramConvert(args)), flagNewSpan.getKey().toString(), urlVal);
                    ContextManager.setMethodCallContextQueue(UUIDMessage);
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block7;
                    System.err.println("onMethodEnter " + method + " " + e.getMessage());
                }
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onExit(@Advice.Origin Method method, @Advice.Return(typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Thrown Throwable thrown) {
            block7: {
                try {
                    if (ContextManager.isMessageIdQueueEmpty()) {
                        return;
                    }
                    if (!YamlParserConfig.getProfilingConfig().getMonitoring().getMonitoringStaticMethod().booleanValue() && UtilsDataConvert.isStaticMethod(method).booleanValue()) {
                        return;
                    }
                    if (UtilsDataConvert.isSerializationContext()) {
                        return;
                    }
                    Object retVal = returned;
                    if (returned instanceof CompletableFuture) {
                        retVal = ((CompletableFuture)returned).thenAccept(UtilsDataConvert::handleResult);
                    }
                    String errorCallMessage = "";
                    if (thrown != null) {
                        errorCallMessage = DataUtils.getaNullThrowable(thrown);
                    }
                    MessageService.sendMessageEnd(ContextManager.getMessageIdQueueNew(), OffsetDateTime.now(), errorCallMessage, ReflectionUtils.objectToString(DataUtils.methodReturnConvert(retVal)), ContextManager.getTraceId(), ContextManager.getSpanId());
                    ContextManager.removeLastQueue();
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block7;
                    System.err.println("onMethodEnter " + method + " " + e.getMessage());
                }
            }
        }
    }
}

