/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import io.bitdive.parent.message_producer.MessageService;
import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import java.lang.reflect.Method;
import java.util.Optional;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddyAgentCatalinaResponse {
    public static void init() {
        new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.named((String)"org.apache.catalina.connector.Request")).transform((builder, typeDescription, classLoader, module, dd) -> builder.visit((AsmVisitorWrapper)Advice.to(CatalinaResponseInterceptor.class).on((ElementMatcher)ElementMatchers.named((String)"finishRequest")))).installOnByteBuddyAgent();
    }

    public static class CatalinaResponseInterceptor {
        @Advice.OnMethodEnter
        public static void onEnter(@Advice.This Object responseObj) {
            block3: {
                try {
                    if (Optional.of(ContextManager.getUrlStart()).orElse("").toLowerCase().contains("/actuator/")) {
                        return;
                    }
                    Class<?> requestClass = responseObj.getClass();
                    Method getResponseMethod = requestClass.getMethod("getResponse", new Class[0]);
                    Object responseInternal = getResponseMethod.invoke(responseObj, new Object[0]);
                    Class<?> responseClass = responseInternal.getClass();
                    Method getStatusMethod = responseClass.getMethod("getStatus", new Class[0]);
                    int status = (Integer)getStatusMethod.invoke(responseInternal, new Object[0]);
                    MessageService.sendMessageWebResponse(ContextManager.getMessageStart(), ContextManager.getTraceId(), ContextManager.getSpanId(), status);
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block3;
                    System.err.println("error call finishRequest for org.apache.catalina.connector.Request  error : " + e.getMessage());
                }
            }
        }
    }
}

