/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddyAgentResponseWeb {
    public static void init() {
        block2: {
            try {
                new AgentBuilder.Default().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).type((ElementMatcher)ElementMatchers.named((String)"org.apache.catalina.connector.CoyoteAdapter")).transform((builder, typeDescription, classLoader, module, dd) -> builder.visit((AsmVisitorWrapper)Advice.to(CoyoteAdapterAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"service").and((ElementMatcher)ElementMatchers.takesArguments((int)2))))).installOnByteBuddyAgent();
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("not found class org.apache.catalina.connector.CoyoteAdapte");
            }
        }
    }

    public static String extractFullUrlFromRequest(Object request) {
        try {
            String serverName;
            String scheme = ByteBuddyAgentResponseWeb.getStringValue(request, "scheme");
            if (scheme == null) {
                scheme = "http";
            }
            if ((serverName = ByteBuddyAgentResponseWeb.getStringValue(request, "serverName")) == null) {
                serverName = "";
            }
            Method getServerPortMethod = request.getClass().getMethod("getServerPort", new Class[0]);
            int serverPort = (Integer)getServerPortMethod.invoke(request, new Object[0]);
            Field queryMBField = request.getClass().getDeclaredField("uriMB");
            queryMBField.setAccessible(true);
            Object uriMBVal = queryMBField.get(request);
            Method cloneUrlMethod = uriMBVal.getClass().getMethod("clone", new Class[0]);
            cloneUrlMethod.setAccessible(true);
            String uri = cloneUrlMethod.invoke(uriMBVal, new Object[0]).toString();
            String queryString = ByteBuddyAgentResponseWeb.getStringValue(request, "queryString");
            if (queryString == null) {
                queryString = "";
            }
            StringBuilder fullUrl = new StringBuilder();
            fullUrl.append(scheme).append("://").append(serverName);
            if (!(scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443)) {
                fullUrl.append(":").append(serverPort);
            }
            fullUrl.append(uri);
            if (!queryString.isEmpty()) {
                fullUrl.append("?").append(queryString);
            }
            return fullUrl.toString();
        }
        catch (Exception e) {
            if (LoggerStatusContent.isErrorsOrDebug()) {
                System.err.println("error get url for response extractFullUrlFromRequest");
            }
            return null;
        }
    }

    private static String getStringValue(Object obj, String methodName) {
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            return result != null ? result.toString() : null;
        }
        catch (Exception e) {
            if (LoggerStatusContent.isErrorsOrDebug()) {
                System.err.println("not found class getStringValue");
            }
            return null;
        }
    }

    public static class CoyoteAdapterAdvice {
        @Advice.OnMethodEnter
        public static void onEnter(@Advice.Argument(value=0) Object request) {
            block4: {
                try {
                    String headersSpanId;
                    ContextManager.createNewRequest();
                    ContextManager.setUrlStart(ByteBuddyAgentResponseWeb.extractFullUrlFromRequest(request));
                    Class<?> requestClass = request.getClass();
                    Method getHeaderMethod = requestClass.getMethod("getHeader", String.class);
                    String headerMessage_Id = (String)getHeaderMethod.invoke(request, "x-BitDiv-custom-parent-message-id");
                    if (headerMessage_Id != null) {
                        ContextManager.setParentMessageIdOtherService(headerMessage_Id);
                    }
                    if ((headersSpanId = (String)getHeaderMethod.invoke(request, "x-BitDiv-custom-span-id")) != null) {
                        ContextManager.setSpanID(headersSpanId);
                    }
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block4;
                    System.err.println("error run service for org.apache.catalina.connector.CoyoteAdapte error: " + e.getMessage());
                }
            }
        }
    }
}

