/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import com.github.f4b6a3.uuid.UuidCreator;
import io.bitdive.parent.message_producer.MessageService;
import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.DataUtils;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.trasirovka.agent.utils.ReflectionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddyAgentRestTemplateRequestWeb {
    public static void init() {
        block2: {
            try {
                Class<?> clientHttpRequestClass = Class.forName("org.springframework.http.client.ClientHttpRequest");
                new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.isSubTypeOf(clientHttpRequestClass)).transform((builder, typeDescription, classLoader, module, dd) -> builder.method((ElementMatcher)ElementMatchers.named((String)"execute")).intercept((Implementation)MethodDelegation.to(ResponseWeRestTemplateInterceptor.class))).installOnByteBuddyAgent();
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("Not found class org.springframework.http.client.ClientHttpRequest in ClassLoader.");
            }
        }
    }

    public static class ResponseWeRestTemplateInterceptor {
        @RuntimeType
        public static Object intercept(@Origin Method method, @SuperCall Callable<?> zuper, @This Object request) throws Exception {
            String errorCall;
            OffsetDateTime dateEnd;
            OffsetDateTime dateStart;
            String responseBody;
            Object responseHeaders;
            String responseStatus;
            String body;
            Object headers;
            String httpMethod;
            String uri;
            Throwable thrown;
            Object retVal;
            block20: {
                if (ContextManager.getMessageIdQueueNew().isEmpty()) {
                    return zuper.call();
                }
                retVal = null;
                thrown = null;
                uri = null;
                httpMethod = null;
                headers = null;
                body = null;
                responseStatus = null;
                responseHeaders = null;
                responseBody = null;
                Object charset = null;
                dateStart = OffsetDateTime.now();
                dateEnd = null;
                errorCall = null;
                try {
                    if (!request.getClass().getName().contains("org.springframework.http.client")) break block20;
                    Method getUriMethod = request.getClass().getMethod("getURI", new Class[0]);
                    getUriMethod.setAccessible(true);
                    uri = Optional.ofNullable(getUriMethod.invoke(request, new Object[0])).map(Object::toString).orElse("");
                    Method getMethodMethod = request.getClass().getMethod("getMethod", new Class[0]);
                    getMethodMethod.setAccessible(true);
                    httpMethod = Optional.ofNullable(getMethodMethod.invoke(request, new Object[0])).map(Object::toString).orElse("");
                    Method getHeadersMethod = request.getClass().getMethod("getHeaders", new Class[0]);
                    getHeadersMethod.setAccessible(true);
                    headers = getHeadersMethod.invoke(request, new Object[0]);
                    Method getBodyMethod = null;
                    try {
                        getBodyMethod = request.getClass().getMethod("getBody", new Class[0]);
                    }
                    catch (Exception e) {
                        getBodyMethod = request.getClass().getDeclaredMethod("getBody", new Class[0]);
                    }
                    try {
                        getBodyMethod.setAccessible(true);
                        body = Optional.ofNullable(getBodyMethod.invoke(request, new Object[0])).map(Object::toString).orElse("");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Method addHeaderMethod = headers.getClass().getMethod("add", String.class, String.class);
                    addHeaderMethod.invoke(headers, "x-BitDiv-custom-span-id", ContextManager.getSpanId());
                    addHeaderMethod.invoke(headers, "x-BitDiv-custom-parent-message-id", ContextManager.getMessageIdQueueNew());
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block20;
                    System.err.println("Error processing ClientHttpRequest: " + e);
                }
            }
            try {
                retVal = zuper.call();
            }
            catch (Throwable t) {
                thrown = t;
                throw t;
            }
            finally {
                block22: {
                    dateEnd = OffsetDateTime.now();
                    if (retVal != null) {
                        try {
                            String responseClassName = retVal.getClass().getName();
                            if (responseClassName.contains("org.springframework.http")) {
                                Method getStatusCodeMethod = retVal.getClass().getMethod("getStatusCode", new Class[0]);
                                getStatusCodeMethod.setAccessible(true);
                                Object statusCode = getStatusCodeMethod.invoke(retVal, new Object[0]);
                                Method valueMethod = statusCode.getClass().getMethod("value", new Class[0]);
                                valueMethod.setAccessible(true);
                                Object statusCodeValue = valueMethod.invoke(statusCode, new Object[0]);
                                responseStatus = statusCodeValue.toString();
                                Method getHeadersMethod = retVal.getClass().getMethod("getHeaders", new Class[0]);
                                getHeadersMethod.setAccessible(true);
                                responseHeaders = getHeadersMethod.invoke(retVal, new Object[0]);
                                Method getBodyMethod = retVal.getClass().getMethod("getBody", new Class[0]);
                                getBodyMethod.setAccessible(true);
                                InputStream originalInputStream = (InputStream)getBodyMethod.invoke(retVal, new Object[0]);
                                Field cachedBodyField = retVal.getClass().getDeclaredField("cachedBody");
                                cachedBodyField.setAccessible(true);
                                byte[] responseBodyBytes = (byte[])cachedBodyField.get(retVal);
                                Charset responseCharset = ResponseWeRestTemplateInterceptor.getResponseCharset(responseHeaders);
                                if (responseCharset == null) {
                                    responseCharset = Charset.defaultCharset();
                                }
                                responseBody = new String(responseBodyBytes, responseCharset);
                            }
                        }
                        catch (Exception e) {
                            if (!LoggerStatusContent.isErrorsOrDebug()) break block22;
                            System.err.println("Error processing ClientHttpResponse: " + e.getMessage());
                        }
                    }
                }
                if (thrown != null) {
                    errorCall = DataUtils.getaNullThrowable(thrown);
                }
                MessageService.sendMessageRequestUrl(UuidCreator.getTimeBased().toString(), ContextManager.getTraceId(), ContextManager.getSpanId(), dateStart, dateEnd, uri, httpMethod, ReflectionUtils.objectToString(headers), ReflectionUtils.objectToString(body), responseStatus, ReflectionUtils.objectToString(responseHeaders), responseBody, errorCall, ContextManager.getMessageIdQueueNew());
            }
            return retVal;
        }

        private static byte[] readAllBytes(InputStream inputStream) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }

        private static Charset getResponseCharset(Object headers) {
            try {
                Method getContentTypeMethod = headers.getClass().getMethod("getContentType", new Class[0]);
                getContentTypeMethod.setAccessible(true);
                Object mediaType = getContentTypeMethod.invoke(headers, new Object[0]);
                if (mediaType != null) {
                    Method getCharsetMethod = mediaType.getClass().getMethod("getCharset", new Class[0]);
                    getCharsetMethod.setAccessible(true);
                    Charset charset = (Charset)getCharsetMethod.invoke(mediaType, new Object[0]);
                    return charset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private static void replaceResponseBodyInputStream(Object response, InputStream newInputStream) throws Exception {
            Field bodyField = null;
            for (Class<?> responseClass = response.getClass(); responseClass != null; responseClass = responseClass.getSuperclass()) {
                try {
                    bodyField = responseClass.getDeclaredField("responseStream");
                    bodyField.setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            if (bodyField != null) {
                bodyField.set(response, newInputStream);
            } else if (LoggerStatusContent.isErrorsOrDebug()) {
                System.err.println("Unable to replace response body InputStream.");
            }
        }
    }
}

