/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import com.github.f4b6a3.uuid.UuidCreator;
import io.bitdive.parent.message_producer.MessageService;
import io.bitdive.parent.trasirovka.agent.utils.ContextManager;
import io.bitdive.parent.trasirovka.agent.utils.DataUtils;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.trasirovka.agent.utils.SQLUtils;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.time.OffsetDateTime;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddyAgentSql {
    public static void init() {
        new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.isSubTypeOf(PreparedStatement.class).or((ElementMatcher)ElementMatchers.isSubTypeOf(Statement.class)).and((ElementMatcher)ElementMatchers.nameContains((String)"jdbc"))).transform((builder, typeDescription, classLoader, module, dd) -> builder.visit((AsmVisitorWrapper)Advice.to(SqlAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"executeQuery").or((ElementMatcher)ElementMatchers.named((String)"executeUpdate")).or((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameContains((String)"Internal")))))).installOnByteBuddyAgent();
    }

    public static class SqlAdvice {
        @Advice.OnMethodEnter
        public static MethodContext onEnter(@Advice.This Object stmt, @Advice.Origin Method method) {
            MethodContext context;
            block3: {
                context = new MethodContext();
                String sqlFromStatement = SQLUtils.getSQLFromStatement(stmt);
                String connectionUrl = SQLUtils.getConnectionUrlFromStatement(stmt);
                context.flagNoMonitoring = sqlFromStatement == null || sqlFromStatement.isEmpty();
                context.traceId = ContextManager.getTraceId();
                context.spanId = ContextManager.getSpanId();
                context.UUIDMessage = UuidCreator.getTimeBased().toString();
                try {
                    if (!context.flagNoMonitoring && !ContextManager.isMessageIdQueueEmpty()) {
                        MessageService.sendMessageSQLStart(context.UUIDMessage, context.traceId, context.spanId, sqlFromStatement, connectionUrl, OffsetDateTime.now(), ContextManager.getMessageIdQueueNew());
                    }
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block3;
                    System.err.println("Error sending SQL start message: " + e.getMessage());
                }
            }
            return context;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onExit(@Advice.Enter MethodContext context, @Advice.Thrown Throwable throwable, @Advice.Return Object returnValue) {
            block3: {
                try {
                    if (!context.flagNoMonitoring && !ContextManager.isMessageIdQueueEmpty()) {
                        MessageService.sendMessageSQLEnd(context.UUIDMessage, context.traceId, context.spanId, OffsetDateTime.now(), DataUtils.getaNullThrowable(throwable));
                    }
                }
                catch (Exception e) {
                    if (!LoggerStatusContent.isErrorsOrDebug()) break block3;
                    System.err.println("Error sending SQL end message: " + e.getMessage());
                }
            }
        }

        public static class MethodContext {
            public boolean flagNoMonitoring;
            public String traceId;
            public String spanId;
            public String UUIDMessage;
        }
    }
}

