/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.byte_buddy_agent;

import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ByteBuddySimpleClientHttpResponse {
    public static void init() {
        block2: {
            try {
                Class<?> clientClass = Class.forName("org.springframework.http.client.ClientHttpResponse");
                new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.nameContains((String)"org.springframework").and((ElementMatcher)ElementMatchers.isSubTypeOf(clientClass))).transform((builder, typeDescription, classLoader, module, dd) -> builder.defineField("cachedBody", byte[].class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.named((String)"getBody")).intercept((Implementation)MethodDelegation.to(GetBodyInterceptor.class))).installOnByteBuddyAgent();
            }
            catch (Exception e) {
                if (!LoggerStatusContent.isErrorsOrDebug()) break block2;
                System.err.println("Not found class feign.Client in ClassLoader.");
            }
        }
    }

    public static class GetBodyInterceptor {
        @RuntimeType
        public static InputStream intercept(@SuperCall Callable<InputStream> zuper, @This Object obj) throws Exception {
            Field cachedBodyField = obj.getClass().getDeclaredField("cachedBody");
            cachedBodyField.setAccessible(true);
            byte[] cachedBody = (byte[])cachedBodyField.get(obj);
            if (cachedBody != null) {
                return new ByteArrayInputStream(cachedBody);
            }
            InputStream originalInputStream = zuper.call();
            byte[] responseBodyBytes = GetBodyInterceptor.readAllBytes(originalInputStream);
            cachedBodyField.set(obj, responseBodyBytes);
            return new ByteArrayInputStream(responseBodyBytes);
        }

        private static byte[] readAllBytes(InputStream inputStream) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
    }
}

