/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.utils;

import io.bitdive.parent.dto.TraceMethodContext;
import java.util.Deque;
import java.util.Optional;

public class ContextManager {
    private static final ThreadLocal<TraceMethodContext> contextThreadLocal = ThreadLocal.withInitial(TraceMethodContext::new);

    public static void createNewRequest() {
        contextThreadLocal.set(new TraceMethodContext());
    }

    public static void setSpanID(String spanId) {
        ContextManager.getContestThreadLocalOptional().ifPresent(traceMethodContext -> traceMethodContext.setSpanId(spanId));
    }

    public static void setParentMessageIdOtherService(String parentId) {
        ContextManager.getContestThreadLocalOptional().ifPresent(traceMethodContext -> traceMethodContext.setParentIdForRest(parentId));
    }

    public static void setContextThread(TraceMethodContext value) {
        TraceMethodContext traceMethodContext = new TraceMethodContext();
        traceMethodContext.setTraceId(value.getTraceId());
        traceMethodContext.setSpanId(value.getSpanId());
        traceMethodContext.setParentIdForRest(value.getParentIdForRest());
        traceMethodContext.setUrlStart(value.getUrlStart());
        traceMethodContext.setStartMessageId(value.getStartMessageId());
        if (!value.getMethodCallContextQueue().isEmpty()) {
            traceMethodContext.getMethodCallContextQueue().offerLast((String)value.getMethodCallContextQueue().peekLast());
        }
        contextThreadLocal.set(traceMethodContext);
    }

    public static String getMessageStart() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getStartMessageId).orElse("");
    }

    public static void setUrlStart(String urlStart) {
        ContextManager.getContestThreadLocalOptional().ifPresent(traceMethodContext -> traceMethodContext.setUrlStart(urlStart));
    }

    public static String getUrlStart() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getUrlStart).orElse("null");
    }

    public static TraceMethodContext getContext() {
        return contextThreadLocal.get();
    }

    public static String getTraceId() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getTraceId).orElseThrow(() -> new RuntimeException("TraceId not found"));
    }

    public static String getSpanId() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getSpanId).orElse(null);
    }

    private static String getMessageIdQueue() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getMethodCallContextQueue).map(Deque::peekLast).orElse("");
    }

    public static String getMessageIdQueueNew() {
        return ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getMethodCallContextQueue).map(Deque::peekLast).orElse("");
    }

    public static String getParentIdMessageIdQueue() {
        return ContextManager.getContestThreadLocalOptional().filter(traceMethodContext -> !traceMethodContext.getMethodCallContextQueue().isEmpty()).map(TraceMethodContext::getMethodCallContextQueue).map(Deque::peekLast).orElse(ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getParentIdForRest).orElse(""));
    }

    public static boolean isMessageIdQueueEmpty() {
        return ContextManager.getMessageIdQueue().isEmpty();
    }

    public static void setMethodCallContextQueue(String methodCallId) {
        ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getMethodCallContextQueue).map(queue -> queue.offerLast(methodCallId));
    }

    public static void removeLastQueue() {
        ContextManager.getContestThreadLocalOptional().map(TraceMethodContext::getMethodCallContextQueue).ifPresent(Deque::pollLast);
    }

    private static Optional<TraceMethodContext> getContestThreadLocalOptional() {
        return Optional.ofNullable(contextThreadLocal.get());
    }
}

