/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.trasirovka.agent.utils;

import io.bitdive.parent.anotations.NotMonitoringParamsClass;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JsonSerializer {
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();
    private static final int MAX_DEPTH = 10;
    private static final int MAX_COLLECTION_SIZE = YamlParserConfig.getProfilingConfig().getMonitoring().getSerialization().getMaxElementCollection();
    private static final String INDICATOR = "...";
    private static final Set<String> SENSITIVE_KEYWORDS = new HashSet<String>(Arrays.asList("password", "pass", "secret", "token", "key", "apiKey", "auth", "credential"));

    public static String serialize(Object obj) {
        try {
            if (obj == null) {
                return "null";
            }
            try {
                String[] excludedPackages;
                if (obj.getClass().isAnnotationPresent(NotMonitoringParamsClass.class)) {
                    NotMonitoringParamsClass annotation = obj.getClass().getAnnotation(NotMonitoringParamsClass.class);
                    return "\"" + annotation.value() + "\"";
                }
                for (String pkg : excludedPackages = YamlParserConfig.getProfilingConfig().getMonitoring().getSerialization().getExcludedPackages()) {
                    if (!obj.getClass().getName().startsWith(pkg)) continue;
                    try {
                        return "\"" + obj.toString() + "\"";
                    }
                    catch (Exception e) {
                        return "\"[Error in toString()]\"";
                    }
                }
                StringBuilder sb = new StringBuilder();
                HashSet<Object> visited = new HashSet<Object>();
                JsonSerializer.serializeValue(obj, sb, visited, 0);
                return sb.toString();
            }
            catch (Exception e) {
                return "\"[Error: " + e.getMessage() + "]\"";
            }
        }
        catch (Throwable t) {
            return "\"Error converting data\"";
        }
    }

    private static void serializeValue(Object value, StringBuilder sb, Set<Object> visited, int depth) {
        if (depth > 10) {
            sb.append("\"[MAX_DEPTH_REACHED]\"");
            return;
        }
        if (value == null) {
            sb.append("null");
            return;
        }
        if (JsonSerializer.shouldSkipValue(value)) {
            sb.append("null");
            return;
        }
        Class<?> clazz = value.getClass();
        if (value instanceof Enum) {
            JsonSerializer.serializeString(((Enum)value).name(), sb);
            return;
        }
        if (visited.contains(value)) {
            sb.append("\"[CIRCULAR_REFERENCE]\"");
            return;
        }
        if (value instanceof byte[]) {
            sb.append("\"byte_array\"");
            return;
        }
        if (clazz.isPrimitive() || value instanceof Number || value instanceof Boolean) {
            sb.append(value);
        } else if (value instanceof String || value instanceof Character) {
            JsonSerializer.serializeString(value.toString(), sb);
        } else if (value instanceof Collection) {
            JsonSerializer.serializeCollection((Collection)value, sb, visited, depth);
        } else if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                JsonSerializer.serializePrimitiveArray(value, sb);
            } else {
                JsonSerializer.serializeArray(value, sb, visited, depth);
            }
        } else if (value instanceof Map) {
            JsonSerializer.serializeMap((Map)value, sb, visited, depth);
        } else {
            JsonSerializer.serializeObject(value, sb, visited, depth);
        }
    }

    private static boolean shouldSkipValue(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        return JsonSerializer.isHibernateProxy(clazz) || JsonSerializer.isPersistentCollection(clazz);
    }

    private static boolean isHibernateProxy(Class<?> clazz) {
        return JsonSerializer.isClassInHierarchy(clazz, "org.hibernate.proxy.HibernateProxy");
    }

    private static boolean isPersistentCollection(Class<?> clazz) {
        return JsonSerializer.isClassInHierarchy(clazz, "org.hibernate.collection.spi.PersistentCollection");
    }

    private static boolean isClassInHierarchy(Class<?> clazz, String targetClassName) {
        while (clazz != null) {
            if (clazz.getName().equals(targetClassName)) {
                return true;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!iface.getName().equals(targetClassName) && !JsonSerializer.isClassInHierarchy(iface, targetClassName)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private static void serializeString(String str, StringBuilder sb) {
        sb.append('\"');
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    private static void serializeCollection(Collection<?> collection, StringBuilder sb, Set<Object> visited, int depth) {
        sb.append('[');
        boolean first = true;
        visited.add(collection);
        int count = 0;
        for (Object item : collection) {
            if (count >= MAX_COLLECTION_SIZE) {
                if (!first) {
                    sb.append(',');
                }
                JsonSerializer.serializeString(INDICATOR, sb);
                break;
            }
            if (!first) {
                sb.append(',');
            }
            JsonSerializer.serializeValue(item, sb, visited, depth + 1);
            first = false;
            ++count;
        }
        visited.remove(collection);
        sb.append(']');
    }

    private static void serializeArray(Object array, StringBuilder sb, Set<Object> visited, int depth) {
        sb.append('[');
        int length = Array.getLength(array);
        visited.add(array);
        int maxElements = Math.min(length, MAX_COLLECTION_SIZE);
        for (int i = 0; i < maxElements; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            JsonSerializer.serializeValue(Array.get(array, i), sb, visited, depth + 1);
        }
        if (length > MAX_COLLECTION_SIZE) {
            sb.append(',');
            JsonSerializer.serializeString(INDICATOR, sb);
        }
        visited.remove(array);
        sb.append(']');
    }

    private static void serializePrimitiveArray(Object array, StringBuilder sb) {
        sb.append('[');
        int length = Array.getLength(array);
        int maxElements = Math.min(length, MAX_COLLECTION_SIZE);
        for (int i = 0; i < maxElements; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Object element = Array.get(array, i);
            sb.append(element);
        }
        if (length > MAX_COLLECTION_SIZE) {
            sb.append(',');
            JsonSerializer.serializeString(INDICATOR, sb);
        }
        sb.append(']');
    }

    private static void serializeMap(Map<?, ?> map, StringBuilder sb, Set<Object> visited, int depth) {
        sb.append('{');
        boolean first = true;
        visited.add(map);
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (count >= MAX_COLLECTION_SIZE) {
                if (!first) {
                    sb.append(',');
                }
                JsonSerializer.serializeString(INDICATOR, sb);
                sb.append(':');
                JsonSerializer.serializeString(INDICATOR, sb);
                break;
            }
            if (!first) {
                sb.append(',');
            }
            String key = String.valueOf(entry.getKey());
            JsonSerializer.serializeString(key, sb);
            sb.append(':');
            if (JsonSerializer.isSensitiveField(key)) {
                sb.append("\"******\"");
            } else {
                JsonSerializer.serializeValue(entry.getValue(), sb, visited, depth + 1);
            }
            first = false;
            ++count;
        }
        visited.remove(map);
        sb.append('}');
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        while (clazz != null && clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private static void serializeObject(Object obj, StringBuilder sb, Set<Object> visited, int depth) {
        Class<?> clazz = obj.getClass();
        if (JsonSerializer.isHibernateProxy(clazz)) {
            sb.append("\"[HIBERNATE_PROXY]\"");
            return;
        }
        try {
            Field[] fields = FIELDS_CACHE.computeIfAbsent(clazz, JsonSerializer::getDeclaredFields);
            sb.append('{');
            boolean first = true;
            visited.add(obj);
            for (Field field : fields) {
                try {
                    Field actualField = JsonSerializer.getField(obj.getClass(), field.getName());
                    if (actualField == null) continue;
                    Object value = field.get(obj);
                    if (!first) {
                        sb.append(',');
                    }
                    JsonSerializer.serializeString(field.getName(), sb);
                    sb.append(':');
                    JsonSerializer.serializeValue(value, sb, visited, depth + 1);
                    first = false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            visited.remove(obj);
            sb.append('}');
        }
        catch (Exception e) {
            try {
                JsonSerializer.serializeString(obj.toString(), sb);
            }
            catch (Exception ex) {
                sb.append("\"[Object cannot be serialized]\"");
            }
        }
    }

    private static boolean isSensitiveField(String fieldName) {
        String lowerCaseField = fieldName.toLowerCase();
        return SENSITIVE_KEYWORDS.stream().anyMatch(keyword -> lowerCaseField.contains(keyword.toLowerCase()));
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                field.setAccessible(true);
                fieldList.add(field);
            }
        }
        return fieldList.toArray(new Field[0]);
    }
}

