/*
 * Decompiled with CFR 0.152.
 */
package io.bitdive.parent.utils;

import io.bitdive.parent.message_producer.HttpURLConnectionCustom;
import io.bitdive.parent.message_producer.HttpsURLConnectionCustom;
import io.bitdive.parent.message_producer.LocalCryptoService;
import io.bitdive.parent.parserConfig.YamlParserConfig;
import io.bitdive.parent.safety_config.SSLContextCustomBitDive;
import io.bitdive.parent.trasirovka.agent.utils.LoggerStatusContent;
import io.bitdive.parent.utils.MethodTypeEnum;
import io.bitdive.parent.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;

public class UtilsDataConvert {
    private static final Map<String, Pair<MethodTypeEnum, Boolean>> mapNewSpan = new ConcurrentHashMap<String, Pair<MethodTypeEnum, Boolean>>();
    private static final Map<String, Boolean> mapStaticMethod = new ConcurrentHashMap<String, Boolean>();
    private static final List<String> listNewFlagComponent = Arrays.asList("org.springframework.web.bind.annotation", "Scheduled");

    public static Object handleResult(Object result) {
        return result;
    }

    public static Boolean isStaticMethod(Method method) {
        String findClassAndMethod = String.format("%s//%s", method.getDeclaringClass().getName(), method.getName());
        return mapStaticMethod.computeIfAbsent(findClassAndMethod, key -> Modifier.isStatic(method.getModifiers()));
    }

    public static boolean isSerializationContext() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("io.bitdive.parent.trasirovka.agent.utils.ReflectionUtils")) continue;
            return true;
        }
        return false;
    }

    public static Pair<MethodTypeEnum, Boolean> identificationMethod(Method method) {
        String findClassAndMethod = String.format("%s//%s", method.getDeclaringClass().getName(), method.getName());
        return mapNewSpan.computeIfAbsent(findClassAndMethod, key -> {
            Annotation[] annotations = method.getDeclaredAnnotations();
            boolean isNewSpan = false;
            MethodTypeEnum methodType = MethodTypeEnum.METHOD;
            block0: for (Annotation annotation : annotations) {
                if (listNewFlagComponent.stream().anyMatch(s -> annotation.annotationType().getPackage().getName().contains((CharSequence)s))) {
                    isNewSpan = true;
                }
                for (MethodTypeEnum methodTypeEnum : MethodTypeEnum.getListMethodFlagInPoint()) {
                    if (!annotation.annotationType().getName().contains(methodTypeEnum.getAnnotationName())) continue;
                    methodType = methodTypeEnum;
                    continue block0;
                }
            }
            return new Pair<MethodTypeEnum, Boolean>(methodType, isNewSpan);
        });
    }

    /*
     * Exception decompiling
     */
    private static byte[] readFileBytes(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean sendFile(File file, Proxy proxy, String methodOnServer) {
        try {
            int responseCode;
            boolean isSSLSend = YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().isSSLSend();
            if (isSSLSend) {
                SSLContextCustomBitDive.ensureValidCertificate();
            }
            byte[] fileBytes = UtilsDataConvert.readFileBytes(file);
            String base64Data = Base64.getEncoder().encodeToString(fileBytes);
            Pair<Integer, String> encryptedData = isSSLSend ? LocalCryptoService.encrypt(base64Data) : Pair.createPair(-1, base64Data);
            Pair<Integer, String> signature = isSSLSend ? LocalCryptoService.sign(encryptedData.getVal()) : Pair.createPair(-1, "");
            URL serverUrl = new URL(YamlParserConfig.getProfilingConfig().getMonitoring().getSendFiles().getServerConsumer().getUrl() + "/" + methodOnServer);
            int n = responseCode = isSSLSend ? HttpsURLConnectionCustom.sentToServer((HttpsURLConnection)serverUrl.openConnection(proxy), file, encryptedData, signature) : HttpURLConnectionCustom.sentToServer((HttpURLConnection)serverUrl.openConnection(proxy), file, encryptedData, signature);
            if (responseCode == 200) {
                if (LoggerStatusContent.isDebug()) {
                    System.out.println("File uploaded successfully: " + file.getName());
                }
                return true;
            }
            if (LoggerStatusContent.isDebug()) {
                System.err.println("Failed to upload file. Response code: " + responseCode);
            }
            return false;
        }
        catch (IOException e) {
            if (LoggerStatusContent.isErrorsOrDebug()) {
                System.err.println("Failed to upload file: " + e);
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e);
            return false;
        }
    }

    public static Proxy initilizationProxy(String proxyHost, String proxyPort, final String proxyUserName, final String proxyPassword) {
        Proxy proxy = Proxy.NO_PROXY;
        if (proxyHost != null && proxyPort != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
            if (proxyUserName != null && proxyPassword != null && !proxyUserName.isEmpty() && !proxyPassword.isEmpty()) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                            return new PasswordAuthentication(proxyUserName, proxyPassword.toCharArray());
                        }
                        return super.getPasswordAuthentication();
                    }
                });
            }
        }
        return proxy;
    }
}

