/*
 * Decompiled with CFR 0.152.
 */
package io.bitunnel.common.camel;

import io.bitunnel.common.camel.BitunnelErrorHandler;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitunnelErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    protected CamelLogger logger;
    protected RedeliveryPolicy redeliveryPolicy;
    protected Processor onRedelivery;
    protected Predicate retryWhile;
    protected String retryWhileRef;
    protected Processor failureProcessor;
    protected Endpoint deadLetter;
    protected String deadLetterUri;
    protected boolean deadLetterHandleNewException = true;
    protected boolean useOriginalMessage;
    protected boolean asyncDelayedRedelivery;
    protected String executorServiceRef;
    protected ScheduledExecutorService executorService;
    protected Processor onPrepareFailure;

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        BitunnelErrorHandler answer = new BitunnelErrorHandler(routeContext.getCamelContext(), processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getExceptionPolicyStrategy(), this.getRetryWhilePolicy(routeContext.getCamelContext()), this.getExecutorService(routeContext.getCamelContext()), this.getOnPrepareFailure());
        this.configure(routeContext, (ErrorHandler)answer);
        return answer;
    }

    public boolean supportTransacted() {
        return false;
    }

    public ErrorHandlerBuilder cloneBuilder() {
        BitunnelErrorHandlerBuilder answer = new BitunnelErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(BitunnelErrorHandlerBuilder other) {
        super.cloneBuilder((ErrorHandlerBuilderSupport)other);
        if (this.logger != null) {
            other.setLogger(this.logger);
        }
        if (this.redeliveryPolicy != null) {
            other.setRedeliveryPolicy(this.redeliveryPolicy.copy());
        }
        if (this.onRedelivery != null) {
            other.setOnRedelivery(this.onRedelivery);
        }
        if (this.retryWhile != null) {
            other.setRetryWhile(this.retryWhile);
        }
        if (this.retryWhileRef != null) {
            other.setRetryWhileRef(this.retryWhileRef);
        }
        if (this.failureProcessor != null) {
            other.setFailureProcessor(this.failureProcessor);
        }
        if (this.deadLetter != null) {
            other.setDeadLetter(this.deadLetter);
        }
        if (this.deadLetterUri != null) {
            other.setDeadLetterUri(this.deadLetterUri);
        }
        other.setDeadLetterHandleNewException(this.deadLetterHandleNewException);
        other.setUseOriginalMessage(this.useOriginalMessage);
        other.setAsyncDelayedRedelivery(this.asyncDelayedRedelivery);
        other.setExecutorServiceRef(this.executorServiceRef);
    }

    public BitunnelErrorHandlerBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public BitunnelErrorHandlerBuilder collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    @Deprecated
    public BitunnelErrorHandlerBuilder redeliverDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public BitunnelErrorHandlerBuilder redeliveryDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public BitunnelErrorHandlerBuilder delayPattern(String delayPattern) {
        this.getRedeliveryPolicy().delayPattern(delayPattern);
        return this;
    }

    public BitunnelErrorHandlerBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public BitunnelErrorHandlerBuilder disableRedelivery() {
        this.getRedeliveryPolicy().maximumRedeliveries(0);
        return this;
    }

    public BitunnelErrorHandlerBuilder maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public BitunnelErrorHandlerBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public BitunnelErrorHandlerBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public BitunnelErrorHandlerBuilder retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getRedeliveryPolicy().setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public BitunnelErrorHandlerBuilder retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getRedeliveryPolicy().setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public BitunnelErrorHandlerBuilder logStackTrace(boolean logStackTrace) {
        this.getRedeliveryPolicy().setLogStackTrace(logStackTrace);
        return this;
    }

    public BitunnelErrorHandlerBuilder logRetryStackTrace(boolean logRetryStackTrace) {
        this.getRedeliveryPolicy().setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public BitunnelErrorHandlerBuilder logHandled(boolean logHandled) {
        this.getRedeliveryPolicy().setLogHandled(logHandled);
        return this;
    }

    public BitunnelErrorHandlerBuilder logNewException(boolean logNewException) {
        this.getRedeliveryPolicy().setLogNewException(logNewException);
        return this;
    }

    public BitunnelErrorHandlerBuilder logExhausted(boolean logExhausted) {
        this.getRedeliveryPolicy().setLogExhausted(logExhausted);
        return this;
    }

    public BitunnelErrorHandlerBuilder logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.getRedeliveryPolicy().setLogExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public BitunnelErrorHandlerBuilder exchangeFormatterRef(String exchangeFormatterRef) {
        this.getRedeliveryPolicy().setExchangeFormatterRef(exchangeFormatterRef);
        return this;
    }

    public BitunnelErrorHandlerBuilder asyncDelayedRedelivery() {
        this.getRedeliveryPolicy().setAsyncDelayedRedelivery(true);
        return this;
    }

    public BitunnelErrorHandlerBuilder allowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        this.getRedeliveryPolicy().setAllowRedeliveryWhileStopping(allowRedeliveryWhileStopping);
        return this;
    }

    public BitunnelErrorHandlerBuilder executorServiceRef(String ref) {
        this.setExecutorServiceRef(ref);
        return this;
    }

    public BitunnelErrorHandlerBuilder logger(CamelLogger logger) {
        this.setLogger(logger);
        return this;
    }

    public BitunnelErrorHandlerBuilder loggingLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
        return this;
    }

    public BitunnelErrorHandlerBuilder log(Logger log) {
        this.getLogger().setLog(log);
        return this;
    }

    public BitunnelErrorHandlerBuilder log(String log) {
        return this.log(LoggerFactory.getLogger((String)log));
    }

    public BitunnelErrorHandlerBuilder log(Class<?> log) {
        return this.log(LoggerFactory.getLogger(log));
    }

    public BitunnelErrorHandlerBuilder onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public BitunnelErrorHandlerBuilder retryWhile(Expression retryWhile) {
        this.setRetryWhile(ExpressionToPredicateAdapter.toPredicate((Expression)retryWhile));
        return this;
    }

    public BitunnelErrorHandlerBuilder useOriginalMessage() {
        this.setUseOriginalMessage(true);
        return this;
    }

    public BitunnelErrorHandlerBuilder deadLetterHandleNewException(boolean handleNewException) {
        this.setDeadLetterHandleNewException(handleNewException);
        return this;
    }

    @Deprecated
    public BitunnelErrorHandlerBuilder checkException() {
        this.setDeadLetterHandleNewException(false);
        return this;
    }

    public BitunnelErrorHandlerBuilder onPrepareFailure(Processor processor) {
        this.setOnPrepareFailure(processor);
        return this;
    }

    public Processor getFailureProcessor() {
        return this.failureProcessor;
    }

    public void setFailureProcessor(Processor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = this.createRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public CamelLogger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    public void setLogger(CamelLogger logger) {
        this.logger = logger;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public Predicate getRetryWhilePolicy(CamelContext context) {
        Predicate answer = this.getRetryWhile();
        if (this.getRetryWhileRef() != null) {
            Language bean = context.resolveLanguage("bean");
            answer = bean.createPredicate(this.getRetryWhileRef());
        }
        return answer;
    }

    public Predicate getRetryWhile() {
        return this.retryWhile;
    }

    public void setRetryWhile(Predicate retryWhile) {
        this.retryWhile = retryWhile;
    }

    public String getRetryWhileRef() {
        return this.retryWhileRef;
    }

    public void setRetryWhileRef(String retryWhileRef) {
        this.retryWhileRef = retryWhileRef;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetter = null;
        this.deadLetterUri = deadLetterUri;
    }

    public Endpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void setDeadLetter(Endpoint deadLetter) {
        this.deadLetter = deadLetter;
        this.deadLetterUri = deadLetter.getEndpointUri();
    }

    public boolean isDeadLetterHandleNewException() {
        return this.deadLetterHandleNewException;
    }

    public void setDeadLetterHandleNewException(boolean deadLetterHandleNewException) {
        this.deadLetterHandleNewException = deadLetterHandleNewException;
    }

    public boolean isUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(boolean useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public boolean isAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(boolean asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Processor getOnPrepareFailure() {
        return this.onPrepareFailure;
    }

    public void setOnPrepareFailure(Processor onPrepareFailure) {
        this.onPrepareFailure = onPrepareFailure;
    }

    protected RedeliveryPolicy createRedeliveryPolicy() {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.disableRedelivery();
        return policy;
    }

    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(BitunnelErrorHandler.class), LoggingLevel.ERROR);
    }

    protected synchronized ScheduledExecutorService getExecutorService(CamelContext camelContext) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            if (this.executorServiceRef != null) {
                this.executorService = (ScheduledExecutorService)camelContext.getRegistry().lookupByNameAndType(this.executorServiceRef, ScheduledExecutorService.class);
                if (this.executorService == null) {
                    ExecutorServiceManager manager = camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(this.executorServiceRef);
                    this.executorService = manager.newScheduledThreadPool((Object)this, this.executorServiceRef, profile);
                }
                if (this.executorService == null) {
                    throw new IllegalArgumentException("ExecutorServiceRef " + this.executorServiceRef + " not found in registry.");
                }
            } else {
                this.executorService = null;
            }
        }
        return this.executorService;
    }

    public String toString() {
        return "BitunnelErrorHandlerBuilder";
    }
}

