/*
 * Decompiled with CFR 0.152.
 */
package io.bitunnel.common.db;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import org.apache.log4j.Logger;

public class RedisConnectionFactory {
    private static final Logger logger = Logger.getLogger(RedisConnectionFactory.class);
    private StatefulRedisConnection<String, String> connection = null;
    private RedisClient client = null;
    private String REDIS_MASTER;
    private String REDIS_SLAVE;
    private int REDIS_PORT;

    public StatefulRedisConnection<String, String> getConnection() {
        try {
            if (this.connection == null) {
                this.REDIS_MASTER = System.getenv("REDIS_MASTER");
                this.REDIS_SLAVE = System.getenv("REDIS_SLAVE");
                this.REDIS_PORT = Integer.parseInt(System.getenv("REDIS_PORT"));
                this.client = new RedisClient(this.REDIS_MASTER, this.REDIS_PORT);
                this.connection = this.client.connect();
            }
            this.connection.sync().ping();
            return this.connection;
        }
        catch (Exception e) {
            this.client = null;
            this.connection = null;
            logger.error((Object)"Error getting Redis Connection", (Throwable)e);
            return null;
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.client != null) {
                this.client.shutdown();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error closing Redis Connection", (Throwable)e);
        }
    }
}

