/*
 * Decompiled with CFR 0.152.
 */
package io.bitunnel.common.db;

import io.bitunnel.common.db.RedisConnectionFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.log4j.Logger;

@WebListener
public class RedisContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(RedisContextListener.class);
    static RedisConnectionFactory redisConnectionFactory = null;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext ctx = servletContextEvent.getServletContext();
        try {
            redisConnectionFactory = new RedisConnectionFactory();
            ctx.setAttribute("REDIS_SENTINEL_CONNECTION", (Object)redisConnectionFactory);
        }
        catch (Exception e) {
            logger.error((Object)"Error getting Redis Connection", (Throwable)e);
        }
    }

    public static RedisConnectionFactory getFactoryInstance() {
        return redisConnectionFactory;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        redisConnectionFactory.close();
    }
}

