/*
 * Decompiled with CFR 0.152.
 */
package io.bitunnel.common.security;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.core.MultivaluedMap;

public class OAuthRequestWrapper
extends HttpServletRequestWrapper {
    private MultivaluedMap<String, String> form;

    public OAuthRequestWrapper(HttpServletRequest request, MultivaluedMap<String, String> form) {
        super(request);
        this.form = form;
    }

    public OAuthRequestWrapper(HttpServletRequest request) {
        super(request);
        this.form = null;
    }

    public String getParameter(String name) {
        if ("grant_type".equals(name)) {
            return "authorization_code";
        }
        if ("code".equals(name)) {
            return "code";
        }
        if ("redirect_uri".equals(name)) {
            return "/redirect";
        }
        String value = super.getParameter(name);
        if (value == null) {
            value = this.form != null ? (String)this.form.getFirst((Object)name) : this.getHeader(name);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null && this.form.get((Object)name) != null) {
            values = new String[((List)this.form.get((Object)name)).size()];
            values = ((List)this.form.get((Object)name)).toArray(values);
        }
        return values;
    }
}

