/*
 * Decompiled with CFR 0.152.
 */
package io.bitunnel.common.security;

import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.api.sync.RedisCommands;
import io.bitunnel.common.db.RedisConnectionFactory;
import io.bitunnel.common.security.OAuthRequestWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.rs.request.OAuthAccessResourceRequest;

public class SecureResourceFilter
implements Filter {
    public static final String INVALID_CLIENT_DESCRIPTION = "Client authentication failed (e.g., unknown client, no client authentication included, or unsupported authentication method).";
    public static final String INVALID_TENANT_DESCRIPTION = "Client does not have access to Tenant";
    public static final String RESOURCE_SERVER_NAME = "TradeDepot";
    private FilterConfig config;

    public void setFilterConfig(FilterConfig config) {
        this.config = config;
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    public void init(FilterConfig config) throws ServletException {
        this.setFilterConfig(config);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block20: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String path = "" + request.getServletPath() + request.getPathInfo();
            StatefulRedisConnection<String, String> redisConnection = ((RedisConnectionFactory)this.getFilterConfig().getServletContext().getAttribute("REDIS_SENTINEL_CONNECTION")).getConnection();
            if (path.contains("api-docs")) {
                chain.doFilter(req, res);
            } else {
                if (path.contains("access_token")) {
                    try {
                        try {
                            String tenantId = request.getHeader("tenant_id");
                            OAuthRequestWrapper wrapperRequest = new OAuthRequestWrapper(request);
                            OAuthTokenRequest oauthRequest = new OAuthTokenRequest((HttpServletRequest)wrapperRequest);
                            String clientId = oauthRequest.getClientId();
                            String clientSecret = oauthRequest.getClientSecret();
                            if (redisConnection == null) {
                                this.buildErrorMessage(response, 400, "", "Token Server Not Available");
                                return;
                            }
                            if (!this.validateClientAndSecret(redisConnection, clientId, clientSecret)) {
                                this.buildErrorMessage(response, 400, "invalid_request", INVALID_CLIENT_DESCRIPTION);
                                return;
                            }
                            if (!this.validateTenantPermission(redisConnection, clientId, tenantId)) {
                                this.buildErrorMessage(response, 400, "invalid_request", INVALID_TENANT_DESCRIPTION);
                                return;
                            }
                            chain.doFilter(req, res);
                            break block20;
                        }
                        catch (OAuthProblemException e) {
                            String errorCode = e.getError();
                            if (OAuthUtils.isEmpty((String)errorCode)) {
                                this.buildErrorMessage(response, 400, "", "");
                            } else {
                                this.buildErrorMessage(response, 400, e.getError(), "");
                            }
                            return;
                        }
                    }
                    catch (OAuthSystemException e) {
                        response.setStatus(400);
                        response.setHeader("WWW-Authenticate", e.getMessage());
                        return;
                    }
                }
                try {
                    try {
                        String tenantId = request.getHeader("tenant_id");
                        OAuthAccessResourceRequest oauthRequest = new OAuthAccessResourceRequest(request, new ParameterStyle[]{ParameterStyle.QUERY});
                        String accessToken = oauthRequest.getAccessToken();
                        if (redisConnection == null) {
                            this.buildErrorMessage(response, 400, "", "Token Server Not Available");
                            return;
                        }
                        if (!this.validateToken(redisConnection, accessToken, tenantId)) {
                            this.buildErrorMessage(response, 401, "Invalid Credentials", INVALID_CLIENT_DESCRIPTION);
                            return;
                        }
                        chain.doFilter(req, res);
                    }
                    catch (OAuthProblemException e) {
                        String errorCode = e.getError();
                        if (OAuthUtils.isEmpty((String)errorCode)) {
                            this.buildErrorMessage(response, 400, "", "");
                        } else {
                            this.buildErrorMessage(response, 401, e.getError(), "");
                        }
                        return;
                    }
                }
                catch (OAuthSystemException e) {
                    response.setStatus(400);
                    response.setHeader("WWW-Authenticate", e.getMessage());
                    return;
                }
            }
        }
    }

    private boolean validateClientAndSecret(StatefulRedisConnection<String, String> redisConnection, String clientId, String clientSecret) {
        RedisCommands syncCommands = redisConnection.sync();
        String secret = (String)syncCommands.hget((Object)clientId, (Object)"SECRET");
        return secret != null && secret.equals(clientSecret);
    }

    private boolean validateTenantPermission(StatefulRedisConnection<String, String> redisConnection, String clientId, String tenantId) {
        RedisCommands syncCommands = redisConnection.sync();
        return syncCommands.sismember((Object)("TENANT_PERMISSIONS_" + tenantId), (Object)clientId) != false;
    }

    private boolean validateToken(StatefulRedisConnection<String, String> redisConnection, String accessToken, String tenantId) {
        RedisCommands syncCommands = redisConnection.sync();
        String tenant = (String)syncCommands.hget((Object)accessToken, (Object)"TENANT_ID");
        return tenant != null && tenant.equals(tenantId);
    }

    private void buildErrorMessage(HttpServletResponse response, int statusCode, String error, String errorDescription) throws IOException, OAuthSystemException {
        OAuthResponse.OAuthErrorResponseBuilder builder = OAuthASResponse.errorResponse((int)statusCode).setError(error).setErrorDescription(errorDescription).setRealm(RESOURCE_SERVER_NAME);
        OAuthResponse header = builder.buildHeaderMessage();
        OAuthResponse body = builder.buildJSONMessage();
        response.setContentType("application/json");
        response.setStatus(statusCode);
        response.setHeader("WWW-Authenticate", header.getHeader("WWW-Authenticate"));
        PrintWriter out = response.getWriter();
        out.print(body.getBody());
        out.flush();
    }

    public void destroy() {
    }
}

