/*
 * Decompiled with CFR 0.152.
 */
package io.blocko.coinstack.storage.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.blocko.coinstack.storage.core.Connection;
import io.blocko.coinstack.storage.core.coinstack.StampResult;
import io.blocko.coinstack.storage.core.coinstack.VerifyFileResult;
import io.blocko.coinstack.storage.core.http.HeaderResponse;
import io.blocko.coinstack.storage.core.http.JsonResponse;
import io.blocko.coinstack.storage.core.http.StreamResponse;
import io.blocko.coinstack.storage.exception.CoinstackStorageException;
import io.blocko.coinstack.storage.exception.CoinstackStorageFileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.CharsetUtils;

class VolumeWrapper {
    private Connection connection;
    private ObjectMapper objectMapper = new ObjectMapper();

    VolumeWrapper(Connection Connection2) {
        this.connection = Connection2;
    }

    long uploadFile(String url, String fid, String fileName, InputStream stream, String ttl, ContentType contentType) throws IOException {
        HttpPost request = ttl != null ? new HttpPost(url + "/" + fid + "?ttl=" + ttl) : new HttpPost(url + "/" + fid);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(CharsetUtils.get((String)"UTF-8"));
        builder.addBinaryBody("upload", stream, contentType, fileName);
        HttpEntity entity = builder.build();
        request.setEntity(entity);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        this.convertResponseStatusToException(jsonResponse.statusCode, url, fid, false, false, false, false);
        return ((Integer)((Map)this.objectMapper.readValue(jsonResponse.json, Map.class)).get("size")).intValue();
    }

    void deleteFile(String url, String fid) throws IOException {
        HttpDelete request = new HttpDelete(url + "/" + fid);
        this.convertResponseStatusToException(this.connection.fetchJsonResultByRequest((HttpRequestBase)request).statusCode, url, fid, false, false, false, false);
    }

    boolean checkFileExist(String url, String fid) throws IOException {
        HttpHead request = new HttpHead(url + "/" + fid);
        int statusCode = this.connection.fetchStatusCodeByRequest(request);
        try {
            this.convertResponseStatusToException(statusCode, url, fid, false, true, false, false);
            return true;
        }
        catch (CoinstackStorageFileNotFoundException e) {
            return false;
        }
    }

    StreamResponse getFileStream(String url, String fid) throws IOException {
        HttpGet request = new HttpGet(url + "/" + fid);
        StreamResponse cache = this.connection.fetchStreamCacheByRequest((HttpRequestBase)request);
        this.convertResponseStatusToException(cache.getHttpResponseStatusCode(), url, fid, false, false, false, false);
        return cache;
    }

    VerifyFileResult verifyFile(String url, String fid) throws IOException {
        HttpGet request = new HttpGet(url + "/verify/" + fid);
        JsonResponse verifyResult = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        this.convertResponseStatusToException(verifyResult.statusCode, url, fid, false, false, false, false);
        return (VerifyFileResult)new ObjectMapper().readValue(verifyResult.json, VerifyFileResult.class);
    }

    public StampResult getStamp(String url, String fid) throws IOException {
        HttpGet request = new HttpGet(url + "/stamp/" + fid);
        JsonResponse stampResult = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        this.convertResponseStatusToException(stampResult.statusCode, url, fid, false, false, false, false);
        return (StampResult)new ObjectMapper().readValue(stampResult.json, StampResult.class);
    }

    HeaderResponse getFileStatusHeader(String url, String fid) throws IOException {
        HttpHead request = new HttpHead(url + "/" + fid);
        HeaderResponse cache = this.connection.fetchHeaderByRequest(request);
        this.convertResponseStatusToException(cache.getHttpResponseStatusCode(), url, fid, false, false, false, false);
        return cache;
    }

    private void convertResponseStatusToException(int statusCode, String url, String fid, boolean ignoreNotFound, boolean ignoreRedirect, boolean ignoreRequestError, boolean ignoreServerError) throws CoinstackStorageException {
        switch (statusCode / 100) {
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                if (ignoreRedirect) {
                    return;
                }
                throw new CoinstackStorageException("fetch file from [" + url + "/" + fid + "] is redirect, response stats code is [" + statusCode + "]");
            }
            case 4: {
                if (statusCode == 404 && ignoreNotFound) {
                    return;
                }
                if (statusCode == 404) {
                    throw new CoinstackStorageFileNotFoundException("fetch file from [" + url + "/" + fid + "] is not found, response stats code is [" + statusCode + "]");
                }
                if (ignoreRequestError) {
                    return;
                }
                throw new CoinstackStorageException("fetch file from [" + url + "/" + fid + "] is request error, response stats code is [" + statusCode + "]");
            }
            case 5: {
                if (ignoreServerError) {
                    return;
                }
                throw new CoinstackStorageException("fetch file from [" + url + "/" + fid + "] is request error, response stats code is [" + statusCode + "]");
            }
        }
        throw new CoinstackStorageException("fetch file from [" + url + "/" + fid + "] is error, response stats code is [" + statusCode + "]");
    }
}

